/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared.io;

import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static final String SEPARATOR = "/";

    public static void toZip(File directory) {
        block16: {
            File tmp = null;
            try {
                tmp = FileUtil.createTemporaryFile();
                try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(tmp));){
                    out.setLevel(9);
                    for (File child : directory.listFiles()) {
                        ZipUtil.zip(out, child, directory);
                    }
                }
                File t = new File(directory.toString() + "_$_");
                directory.renameTo(t);
                tmp.renameTo(directory);
                FileUtil.deleteTree(t);
            }
            catch (Throwable t) {
                if (tmp == null) break block16;
                FileUtil.deleteTree(tmp);
            }
        }
    }

    private static void zip(ZipOutputStream out, File file, File base) throws IOException {
        String name = FileUtil.relativize(file, base).toString();
        if (file.isDirectory() && !name.endsWith(SEPARATOR)) {
            name = name + SEPARATOR;
        }
        ZipEntry entry = new ZipEntry(name);
        if (Files.isSymbolicLink(file.toPath())) {
            assert (!entry.isDirectory());
            entry.setComment("->" + Files.readSymbolicLink(file.toPath()).toFile().toString());
            out.putNextEntry(entry);
            out.closeEntry();
        } else if (file.isDirectory()) {
            assert (entry.isDirectory());
            out.putNextEntry(entry);
            out.closeEntry();
            for (File child : file.listFiles()) {
                ZipUtil.zip(out, child, base);
            }
        } else {
            assert (!entry.isDirectory());
            out.putNextEntry(entry);
            try (FileInputStream in = new FileInputStream(file);){
                byte[] buffer = new byte[8192];
                int read = ((InputStream)in).read(buffer, 0, buffer.length);
                while (read > 0) {
                    out.write(buffer, 0, read);
                    read = ((InputStream)in).read(buffer, 0, buffer.length);
                }
            }
            out.closeEntry();
        }
    }
}

