/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.slave.Slave;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SlaveTerminal {
    private final Logger LOGGER = Logger.getLogger("cerberus.slave.terminal");
    private final Slave slave;

    public SlaveTerminal(Slave slave) {
        this.slave = slave;
    }

    public String execute(String command) {
        try {
            String cmd;
            String[] tokens = (String[])Arrays.stream(command.split(" ")).filter(t -> t.length() > 0).toArray(String[]::new);
            switch (cmd = tokens[0]) {
                case "quit": {
                    this.slave.close(0L);
                    return null;
                }
                case "force-quit": {
                    this.slave.close(-1L);
                    return null;
                }
            }
            this.LOGGER.log(Level.WARNING, "unknown command: " + cmd);
            return "unknown command: " + cmd;
        }
        catch (Throwable e) {
            this.LOGGER.log(Level.SEVERE, "unexpected error", e);
            return e.toString();
        }
    }
}

