/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.slave.RememberedEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class SlaveStorage {
    private final File base;
    private final String rememberFileName;
    private final String rememberFileSeperator;
    private final Object rememberFileLocker;

    public SlaveStorage() {
        this("./data");
    }

    public SlaveStorage(String basePath) {
        this.base = new File(basePath);
        this.base.mkdirs();
        this.rememberFileName = "remember.csv";
        this.rememberFileSeperator = ";";
        this.rememberFileLocker = new Object();
    }

    public File getBase() {
        return this.base;
    }

    public File getRememberSection() {
        File f = new File(this.getBase() + File.separator + "remember");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public File getRememberFile() throws IOException {
        File result = new File(this.getRememberSection() + File.separator + this.rememberFileName);
        if (!result.exists()) {
            result.createNewFile();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRememberedEntry(RememberedEntry entry) throws IOException {
        Object object = this.rememberFileLocker;
        synchronized (object) {
            this.appendRememberedEntry(entry.getProjectName(), entry.getId(), entry.getActionName(), entry.getResponsibility(), entry.getCommand(), entry.getDir(), entry.getSuccess(), entry.getLogFile(), entry.getDataFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRememberedEntry(String project, long id, String actionName, Capability responsibility, String[] command, File dir, boolean success, File logFile, File dataFile) throws IOException {
        Object object = this.rememberFileLocker;
        synchronized (object) {
            this.appendRememberedEntry(project, id, actionName, responsibility, Arrays.toString(command), dir, success, logFile, dataFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendRememberedEntry(String project, long id, String actionName, Capability responsibility, String command, File dir, boolean success, File logFile, File dataFile) throws IOException {
        Object object = this.rememberFileLocker;
        synchronized (object) {
            File rememberedFile = this.getRememberFile();
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(rememberedFile, true));){
                bw.append(project + this.rememberFileSeperator + id + this.rememberFileSeperator + actionName + this.rememberFileSeperator + responsibility.toString() + this.rememberFileSeperator + command + this.rememberFileSeperator + dir + this.rememberFileSeperator + success + this.rememberFileSeperator + logFile.getAbsolutePath() + this.rememberFileSeperator + dataFile.getAbsolutePath() + "\n");
                bw.flush();
            }
        }
    }

    public boolean changeRememberedEntry(RememberedEntry toChange) throws IOException {
        RememberedEntry[] currentEntries = this.getRememberedEntries();
        RememberedEntry[] entriesAfterChange = new RememberedEntry[currentEntries.length];
        boolean entryFound = false;
        for (int i = 0; i < currentEntries.length; ++i) {
            RememberedEntry rEntry = currentEntries[i];
            if (rEntry.equals(toChange)) {
                entriesAfterChange[i] = toChange;
                entryFound = true;
                continue;
            }
            entriesAfterChange[i] = rEntry;
        }
        this.cleanAndRewriteRememberedFile(entriesAfterChange);
        return entryFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RememberedEntry[] getRememberedEntries() throws IOException {
        Object object = this.rememberFileLocker;
        synchronized (object) {
            File rememberedFile = this.getRememberFile();
            ArrayList<RememberedEntry> entries = new ArrayList<RememberedEntry>();
            try (BufferedReader br = new BufferedReader(new FileReader(rememberedFile));){
                String s = br.readLine();
                while (s != null) {
                    entries.add(new RememberedEntry(s));
                    s = br.readLine();
                }
            }
            return entries.toArray(new RememberedEntry[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanAndRewriteRememberedFile(RememberedEntry[] entries) throws IOException {
        Object object = this.rememberFileLocker;
        synchronized (object) {
            if (this.getRememberFile().exists()) {
                this.getRememberFile().delete();
            }
            for (RememberedEntry entry : entries) {
                this.appendRememberedEntry(entry);
            }
        }
    }

    public void removeRememberEntryData(RememberedEntry entry) {
        FileUtil.deleteTree(entry.getDir());
        FileUtil.deleteTree(entry.getLogFile().getParentFile());
        FileUtil.deleteTree(entry.getDataFile().getParentFile());
    }

    public File rememberFile(String actionName, String suffix, String data) {
        try {
            File file = this.createRememberFile(actionName, suffix);
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
                bw.write(data);
            }
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    public File createRememberFile(String actionName, String suffix) {
        File randomDir = this.getRandomRememberFile();
        randomDir.mkdirs();
        File file = new File(randomDir + File.separator + actionName + suffix);
        return file;
    }

    public File getRandomRememberFile() {
        long random = -1L;
        Random rng = new Random();
        while ((random = rng.nextLong()) < 0L || new File(this.getRememberSection() + File.separator + "tmp" + random).exists()) {
        }
        return new File(this.getRememberSection() + File.separator + "tmp" + random);
    }
}

