/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.SlaveClosedException;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.Version;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessExecutor;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessOutputListener;
import at.jku.ssw.mevss.cerberus.ci.slave.BuildResult;
import at.jku.ssw.mevss.cerberus.ci.slave.FileConsumer;
import at.jku.ssw.mevss.cerberus.ci.slave.FileProducer;
import at.jku.ssw.mevss.cerberus.ci.slave.SlaveStorage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

public class Slave
implements AutoCloseable {
    private final Logger logger = Logger.getLogger("cerberus.slave");
    private final Object lock;
    private volatile boolean active;
    private volatile int running;
    private final Capability[] capabilities;
    private final SlaveStorage storage;

    public Slave(Capability[] capabilities) {
        this.logger.info("booting (version " + Version.get() + ")");
        this.lock = new Object();
        this.active = true;
        this.running = 0;
        this.logger.info("ready");
        this.capabilities = capabilities;
        this.storage = new SlaveStorage();
    }

    @Override
    public void close() throws InterruptedException {
        this.close(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeout) throws InterruptedException {
        this.logger.info("closing");
        if (timeout < 0L) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                this.lock.notifyAll();
            }
        } else if (timeout == 0L) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.active) {
                    return;
                }
                while (this.running > 0) {
                    this.lock.wait();
                }
                this.active = false;
                this.lock.notifyAll();
            }
        } else {
            if (timeout > 0L) {
                throw new Error("Not implemented!");
            }
            assert (false);
        }
        this.logger.info("closed");
    }

    public BuildResult build(FileProducer producer, String[] command, File workingDirectory, ProcessOutputListener listener, FileConsumer consumer) throws IOException, InterruptedException, SlaveClosedException {
        this.startSlaveWork();
        try {
            this.logger.info("building");
            File srcDirectory = FileUtil.createTemporaryDirectory();
            File buildDirectory = FileUtil.createTemporaryDirectory();
            workingDirectory = new File(srcDirectory + File.separator + workingDirectory);
            this.logger.fine("working in directory " + srcDirectory + " and storing build in " + buildDirectory);
            command = ArraysUtil.append(String.class, command, buildDirectory.getAbsolutePath());
            this.logger.fine("using command " + Arrays.toString(command));
            this.logger.fine("downloading sources");
            producer.produce(srcDirectory);
            this.logger.fine("building");
            int exit = ProcessExecutor.execute(workingDirectory, listener, listener, true, command);
            BuildResult result = new BuildResult(this.logger, srcDirectory, workingDirectory, buildDirectory, this.storage, this::endSlaveWork);
            if (exit != 0) {
                this.logger.info("build failed, disposing result");
                result.dispose();
                result = null;
            } else {
                this.logger.fine("uploading result");
                consumer.consume(buildDirectory);
                this.logger.fine("build succeeded");
            }
            this.logger.info("build finished");
            return result;
        }
        catch (IOException ioe) {
            this.endSlaveWork();
            throw ioe;
        }
        catch (InterruptedException ie) {
            this.endSlaveWork();
            throw ie;
        }
        catch (RuntimeException re) {
            this.endSlaveWork();
            throw re;
        }
        catch (Error e) {
            this.endSlaveWork();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSlaveWork() throws SlaveClosedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                throw new SlaveClosedException();
            }
            ++this.running;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endSlaveWork() {
        Object object = this.lock;
        synchronized (object) {
            --this.running;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean join(long timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.active || this.running > 0) {
                if (timeout == 0L) {
                    this.lock.wait();
                    continue;
                }
                long start = System.currentTimeMillis();
                this.lock.wait(timeout);
                long slept = System.currentTimeMillis() - start;
                if ((timeout -= slept) > 0L) continue;
                break;
            }
            return this.active || this.running > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.lock;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running > 0;
        }
    }

    public BuildResult downloadBuildAndWorkspace(FileProducer buildDownloader, FileProducer workingDirDownloader, String workingDirRoot) throws SlaveClosedException {
        this.startSlaveWork();
        try {
            File buildDirectory = FileUtil.createTemporaryDirectory();
            File workingDirectory = FileUtil.createTemporaryDirectory();
            boolean[] downloadedWithourError = new boolean[]{true, true};
            Thread buildDownloaderThread = new Thread(() -> {
                try {
                    this.logger.fine("start downloading build");
                    buildDownloader.produce(buildDirectory);
                }
                catch (IOException e) {
                    downloadedWithourError[0] = false;
                }
            });
            Thread workingDirDownloaderThread = new Thread(() -> {
                try {
                    this.logger.fine("start downloading working dir");
                    workingDirDownloader.produce(workingDirectory);
                }
                catch (IOException e) {
                    downloadedWithourError[1] = false;
                }
            });
            buildDownloaderThread.start();
            workingDirDownloaderThread.start();
            buildDownloaderThread.join();
            workingDirDownloaderThread.join();
            for (int i = 0; i < downloadedWithourError.length; ++i) {
                if (downloadedWithourError[i]) continue;
                this.logger.warning("download of build / working dir faild");
                this.endSlaveWork();
                return null;
            }
            this.logger.fine("download finnished successful");
            return new BuildResult(this.logger, new File(workingDirectory + File.separator + workingDirRoot), buildDirectory, this.storage, this::endSlaveWork);
        }
        catch (InterruptedException e) {
            this.endSlaveWork();
            return null;
        }
        catch (IOException e1) {
            this.endSlaveWork();
            return null;
        }
    }

    public Capability[] getCapabilities() {
        return this.capabilities;
    }

    public SlaveStorage getStorage() {
        return this.storage;
    }
}

