/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteBuildResult;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteMaster;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProgressListener;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProject;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteSlave;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteTerminal;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.SlaveClosedException;
import at.jku.ssw.mevss.cerberus.ci.shared.Version;
import at.jku.ssw.mevss.cerberus.ci.shared.rmi.RemoteImpl;
import at.jku.ssw.mevss.cerberus.ci.slave.BuildResult;
import at.jku.ssw.mevss.cerberus.ci.slave.FileDownloader;
import at.jku.ssw.mevss.cerberus.ci.slave.FileProducer;
import at.jku.ssw.mevss.cerberus.ci.slave.FileUploader;
import at.jku.ssw.mevss.cerberus.ci.slave.RememberedEntry;
import at.jku.ssw.mevss.cerberus.ci.slave.RemoteBuildResultImpl;
import at.jku.ssw.mevss.cerberus.ci.slave.RemoteProgressListenerAdapter;
import at.jku.ssw.mevss.cerberus.ci.slave.RemoteTerminalImpl;
import at.jku.ssw.mevss.cerberus.ci.slave.Slave;
import at.jku.ssw.mevss.cerberus.ci.slave.SlaveHelper;
import at.jku.ssw.mevss.cerberus.ci.slave.SlaveTerminal;
import java.io.File;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteSlaveImpl
extends RemoteImpl<Slave>
implements RemoteSlave {
    private static final long MASTER_CHECK_INTERVAL = 60000L;
    private final Logger logger;
    private final String id;
    private final String host;
    private final int rmiPort;
    private final RemoteMaster master;
    private final long masterID;

    public RemoteSlaveImpl(String host, int port, int priority, Slave slave) throws NotBoundException, IOException {
        super(slave, "CI_Slave", port * 2);
        String os = SlaveHelper.getProperty("ci.slave.os", "os.name");
        String arch = SlaveHelper.getProperty("ci.slave.arch", "os.arch");
        int length = Integer.parseInt(SlaveHelper.getProperty("ci.slave.addresslength", "sun.arch.data.model"));
        this.logger = Logger.getLogger("cerberus.slave");
        this.id = String.format("%04d_%s", priority, String.valueOf((long)(os.hashCode() ^ arch.hashCode() ^ length) ^ System.currentTimeMillis()));
        this.host = host;
        this.rmiPort = port;
        this.master = SlaveHelper.getMaster(host, this.rmiPort);
        this.masterID = this.master.getID();
        String master_version = this.master.getVersion();
        String my_version = Version.get();
        if (!master_version.equals(my_version)) {
            throw new RemoteException("Version mismatch (master=\"" + master_version + "\", mine=\"" + my_version + "\"!");
        }
        this.master.getSlaveStore().register(this.id, os, arch, length, this);
        this.uploadRememberedFile();
    }

    @Override
    public void dispose() {
        block6: {
            block5: {
                try {
                    if (this.master != null) {
                        this.master.getSlaveStore().unregister(this.id);
                    }
                }
                catch (RemoteException e) {
                    if (this.logger == null) break block5;
                    this.logger.log(Level.WARNING, "error unregistering (" + e + ")");
                }
            }
            super.dispose();
            try {
                ((Slave)this.inner).close();
            }
            catch (InterruptedException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public boolean join() throws InterruptedException {
        while (((Slave)this.inner).join(60000L)) {
            try {
                RemoteMaster master = SlaveHelper.getMaster(this.host, this.rmiPort);
                if (master.getID() == this.masterID && (master.getSlaveStore().isRegistered(this.id) || Arrays.stream(((Slave)this.inner).getCapabilities()).anyMatch(cap -> cap == Capability.PERFORMANCE_TEST) && ((Slave)this.inner).isRunning())) continue;
                return false;
            }
            catch (NotBoundException | RemoteException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public RemoteBuildResult build(int[] tickets, int ticket, String[] command, String workingDirectory, RemoteProgressListener listener) throws RemoteException, SlaveClosedException {
        try {
            BuildResult result;
            int fileServerPort = this.master.getFileServerPort();
            FileProducer[] producers = (FileProducer[])Arrays.stream(tickets).mapToObj(t -> new FileDownloader(this.host, fileServerPort, t)).toArray(FileProducer[]::new);
            FileProducer producer = file -> {
                for (FileProducer p : producers) {
                    p.produce(file);
                }
            };
            FileUploader consumer = new FileUploader(this.host, fileServerPort, ticket);
            try (RemoteProgressListenerAdapter listenerAdapter = new RemoteProgressListenerAdapter(listener);){
                result = ((Slave)this.inner).build(producer, command, new File(workingDirectory), listenerAdapter, consumer);
            }
            return result != null ? new RemoteBuildResultImpl(this, this.logger, this.host, fileServerPort, this.rmiPort, result) : null;
        }
        catch (Throwable t2) {
            this.logger.log(Level.SEVERE, "internal error building", t2);
            return null;
        }
    }

    @Override
    public RemoteTerminal createTerminal() throws RemoteException {
        return new RemoteTerminalImpl(new SlaveTerminal((Slave)this.inner));
    }

    @Override
    public Capability[] getCapabilities() throws RemoteException {
        return ((Slave)this.inner).getCapabilities();
    }

    @Override
    public RemoteBuildResult downloadBuildAndWorkingDir(int buildTicket, int[] workspaceTicket, String workingDirRoot) throws RemoteException, SlaveClosedException {
        try {
            int fileServerPort = this.master.getFileServerPort();
            FileDownloader buildDownloader = new FileDownloader(this.host, fileServerPort, buildTicket);
            FileDownloader[] workspaceDownloaders = (FileDownloader[])Arrays.stream(workspaceTicket).mapToObj(t -> new FileDownloader(this.host, fileServerPort, t)).toArray(FileDownloader[]::new);
            FileProducer workSpaceProducer = file -> {
                for (FileDownloader p : workspaceDownloaders) {
                    p.produce(file);
                }
            };
            BuildResult result = ((Slave)this.inner).downloadBuildAndWorkspace(buildDownloader, workSpaceProducer, workingDirRoot);
            return result != null ? new RemoteBuildResultImpl(this, this.logger, this.host, fileServerPort, this.rmiPort, result) : null;
        }
        catch (Throwable t2) {
            this.logger.log(Level.SEVERE, "internal error downloading build and working directory", t2);
            return null;
        }
    }

    public void uploadRememberedFile() throws IOException {
        RememberedEntry[] entries;
        String os = SlaveHelper.getProperty("ci.slave.os", "os.name");
        String arch = SlaveHelper.getProperty("ci.slave.arch", "os.arch");
        int length = Integer.parseInt(SlaveHelper.getProperty("ci.slave.addresslength", "sun.arch.data.model"));
        ArrayList<RememberedEntry> rewriteEntries = new ArrayList<RememberedEntry>();
        for (RememberedEntry entry : entries = ((Slave)this.inner).getStorage().getRememberedEntries()) {
            if (this.master != null) {
                RemoteProject project;
                try {
                    project = this.master.getProject(entry.getProjectName());
                }
                catch (RemoteException e3) {
                    project = null;
                }
                if (project != null) {
                    BuildInfo info;
                    try {
                        info = project.getBuildInfo(entry.getId(), os, arch, length);
                    }
                    catch (RemoteException e2) {
                        info = null;
                    }
                    if (info != null) {
                        int dirUploadTicket = 0;
                        int logUploadTicket = 0;
                        int dataUploadTicket = 0;
                        try {
                            dirUploadTicket = project.createActionUploadTicket(new BuildID(entry.getId(), os, arch, length), entry.getResponsibility(), entry.getActionName());
                            logUploadTicket = project.createActionLogUploadTicket(new BuildID(entry.getId(), os, arch, length), entry.getResponsibility(), entry.getActionName());
                            dataUploadTicket = project.createActionDataUploadTicket(new BuildID(entry.getId(), os, arch, length), entry.getResponsibility(), entry.getActionName());
                        }
                        catch (RemoteException e1) {
                            dirUploadTicket = 0;
                            logUploadTicket = 0;
                            dataUploadTicket = 0;
                        }
                        if (dirUploadTicket > 0 && logUploadTicket > 0 && dataUploadTicket > 0) {
                            try {
                                boolean writeActionEntrySuccessful = project.writeActionEntry(new BuildID(entry.getId(), os, arch, length), entry.getResponsibility(), entry.getActionName(), entry.getSuccess());
                                if (!writeActionEntrySuccessful) continue;
                                FileUploader uploader = new FileUploader(this.host, this.master.getFileServerPort(), dirUploadTicket);
                                uploader.consume(entry.getDir());
                                uploader = new FileUploader(this.host, this.master.getFileServerPort(), logUploadTicket);
                                uploader.consume(entry.getLogFile());
                                uploader = new FileUploader(this.host, this.master.getFileServerPort(), dataUploadTicket);
                                uploader.consume(entry.getDataFile());
                                ((Slave)this.inner).getStorage().removeRememberEntryData(entry);
                                this.logger.info("Remember file upload: Entry uploaded. " + entry);
                            }
                            catch (Exception e) {
                                this.logger.warning("Remember file upload: something failed during upload. " + entry + "\n\n" + e);
                                rewriteEntries.add(entry);
                            }
                            continue;
                        }
                        this.logger.warning("Remember file upload: project did not generate correct upload tickets. " + entry);
                        rewriteEntries.add(entry);
                        continue;
                    }
                    this.logger.warning("Remember file upload: master and project found, but ID unknown: throw away remembered info " + entry);
                    ((Slave)this.inner).getStorage().removeRememberEntryData(entry);
                    continue;
                }
                this.logger.warning("Remember file upload: master not reachable or project not found at master (project not loaded). " + entry);
                rewriteEntries.add(entry);
                continue;
            }
            this.logger.warning("Remember file upload: master was null. " + entry);
            rewriteEntries.add(entry);
        }
        ((Slave)this.inner).getStorage().cleanAndRewriteRememberedFile(rewriteEntries.toArray(new RememberedEntry[rewriteEntries.size()]));
    }
}

