/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProgressListener;
import at.jku.ssw.mevss.cerberus.ci.shared.ManagedCall;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessOutputListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.rmi.RemoteException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteProgressListenerAdapter
implements ProcessOutputListener,
AutoCloseable {
    private final RemoteProgressListener adaptee;
    private final LinkedBlockingQueue<String> messages;
    private final Thread worker;

    public RemoteProgressListenerAdapter(RemoteProgressListener adaptee) {
        this.adaptee = adaptee;
        this.messages = new LinkedBlockingQueue();
        this.worker = new Thread(this::run, "RemoteProgressListenerAdapter Worker");
        this.worker.start();
    }

    @Override
    public void log(String line) throws IOException {
        try {
            if (!this.worker.isAlive()) {
                throw new IOException("Worker thread terminated, message will not be consumed!");
            }
            this.messages.put(line);
        }
        catch (InterruptedException e) {
            assert (false) : "here be dragons";
            throw new InterruptedIOException();
        }
    }

    @Override
    public void close() throws Exception {
        this.worker.interrupt();
        this.worker.join();
    }

    private void run() {
        assert (Thread.currentThread() == this.worker);
        Logger logger = Logger.getLogger("cerberus.progress");
        while (!this.worker.isInterrupted()) {
            try {
                String line = this.messages.take();
                ManagedCall.invokeAndRetry(InterruptedException.class, () -> this.adaptee.log(line), 60000L, 2);
            }
            catch (InterruptedException e) {
                this.worker.interrupt();
            }
            catch (RemoteException e) {
                logger.log(Level.SEVERE, "error occoured sending log messages", e);
                this.worker.interrupt();
            }
        }
    }
}

