/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import java.io.File;

public class RememberedEntry {
    private String projectName;
    private long id;
    private String actionName;
    private Capability responsibility;
    private String command;
    private File dir;
    private boolean success;
    private File logFile;
    private File dataFile;

    public RememberedEntry(String entryLine) {
        String[] parts = entryLine.split(";");
        assert (parts.length == 9);
        int projectNameId = 0;
        int idId = 1;
        int actionNameId = 2;
        int responsibilityId = 3;
        int commandId = 4;
        int dirId = 5;
        int successId = 6;
        int logId = 7;
        int dataId = 8;
        this.projectName = parts[projectNameId];
        this.id = Long.parseLong(parts[idId]);
        this.actionName = parts[actionNameId];
        this.responsibility = Capability.valueOf(parts[responsibilityId]);
        this.command = parts[commandId];
        this.dir = new File(parts[dirId]);
        this.success = Boolean.parseBoolean(parts[successId]);
        this.logFile = new File(parts[logId]);
        this.dataFile = new File(parts[dataId]);
    }

    public RememberedEntry(String projectName, long id, String actionName, Capability responsibility, String command, File dir, boolean success, File logFile, File dataFile) {
        this.projectName = projectName;
        this.id = id;
        this.actionName = actionName;
        this.responsibility = responsibility;
        this.command = command;
        this.dir = dir;
        this.success = success;
        this.logFile = logFile;
        this.dataFile = dataFile;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public long getId() {
        return this.id;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getCommand() {
        return this.command;
    }

    public File getDir() {
        return this.dir;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public Capability getResponsibility() {
        return this.responsibility;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setResponsibility(Capability responsibility) {
        this.responsibility = responsibility;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public void setDataFile(File dataFile) {
        this.dataFile = dataFile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionName == null ? 0 : this.actionName.hashCode());
        result = 31 * result + (this.command == null ? 0 : this.command.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.projectName == null ? 0 : this.projectName.hashCode());
        result = 31 * result + (this.responsibility == null ? 0 : this.responsibility.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RememberedEntry other = (RememberedEntry)obj;
        if (this.actionName == null ? other.actionName != null : !this.actionName.equals(other.actionName)) {
            return false;
        }
        if (this.command == null ? other.command != null : !this.command.equals(other.command)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.projectName == null ? other.projectName != null : !this.projectName.equals(other.projectName)) {
            return false;
        }
        return this.responsibility == other.responsibility;
    }

    public String toString() {
        return "RememberedEntry [projectName=" + this.projectName + ", id=" + this.id + ", actionName=" + this.actionName + ", responsibility=" + this.responsibility + ", command=" + this.command + ", dir=" + this.dir + ", success=" + this.success + ", logFile=" + this.logFile + ", dataFile=" + this.dataFile + "]";
    }
}

