/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.slave.RemoteSlaveImpl;
import at.jku.ssw.mevss.cerberus.ci.slave.Slave;
import java.rmi.ConnectException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static final long CONNECT_INTERVAL = 60000L;

    public static void main(String[] args) {
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int priority = Integer.parseInt(args[2]);
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        for (int i = 3; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-build")) {
                capabilities.add(Capability.BUILD);
                continue;
            }
            if (args[i].equalsIgnoreCase("-test")) {
                capabilities.add(Capability.FUNCTIONAL_TEST);
                continue;
            }
            if (!args[i].equalsIgnoreCase("-performance")) continue;
            capabilities.add(Capability.PERFORMANCE_TEST);
        }
        Main.main(host, port, priority, capabilities.toArray(new Capability[0]));
    }

    public static void main(String host, int port, int priority, Capability[] capabilities) {
        boolean ok;
        try {
            boolean connect;
            do {
                Logger.getLogger("cerberus.slave").fine("trying to connect");
                try (RemoteSlaveImpl remote = new RemoteSlaveImpl(host, port, priority, new Slave(capabilities));){
                    Logger.getLogger("cerberus.slave").info("connected");
                    connect = !remote.join();
                }
                catch (ConnectException e) {
                    Logger.getLogger("cerberus.slave").fine("connection failed - master unreachable, retrying (" + e + ")");
                    Thread.sleep(60000L);
                    connect = true;
                }
            } while (connect);
            ok = true;
        }
        catch (Throwable e) {
            Logger.getLogger("cerberus.slave").log(Level.SEVERE, "internal error", e);
            ok = false;
        }
        System.exit(ok ? 0 : 1);
    }
}

