/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.interfaces.filetransfer.FileTransferProtocol;
import at.jku.ssw.mevss.cerberus.ci.slave.FileProducer;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDownloader
implements FileProducer {
    private static final Logger LOGGER = Logger.getLogger("cerberus.filedownloader");
    private final String host;
    private final int port;
    private final int ticket;

    public FileDownloader(String host, int port, int ticket) {
        this.host = host;
        this.port = port;
        this.ticket = ticket;
    }

    @Override
    public void produce(File directory) throws IOException {
        try (Socket socket = new Socket(this.host, this.port);){
            ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
            out.writeInt(this.ticket);
            out.flush();
            new FileTransferProtocol(String.valueOf(this.ticket)).read(null, directory, in);
            out.close();
            in.close();
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "error downloading", e);
        }
    }
}

