/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.slave;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessExecutor;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessOutputListener;
import at.jku.ssw.mevss.cerberus.ci.slave.FileConsumer;
import at.jku.ssw.mevss.cerberus.ci.slave.RememberedEntry;
import at.jku.ssw.mevss.cerberus.ci.slave.SlaveStorage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BuildResult {
    private static final int TRIES = 10;
    private static final long SLEEP_TIME = 60000L;
    private final SlaveStorage storage;
    private final Logger logger;
    private final File srcDirectory;
    private final File workingDirectory;
    private final File buildDirectory;
    private final Runnable on_dispose;

    public BuildResult(Logger logger, File workingDirectory, File buildDirectory, SlaveStorage storage, Runnable on_dispose) {
        this.logger = logger;
        this.srcDirectory = null;
        this.workingDirectory = workingDirectory;
        this.buildDirectory = buildDirectory;
        this.storage = storage;
        this.on_dispose = on_dispose;
    }

    public BuildResult(Logger logger, File srcDirectory, File workingDirectory, File buildDirectory, SlaveStorage storage, Runnable on_dispose) {
        this.logger = logger;
        this.srcDirectory = srcDirectory;
        this.workingDirectory = workingDirectory;
        this.buildDirectory = buildDirectory;
        this.storage = storage;
        this.on_dispose = on_dispose;
    }

    public void dispose() {
        this.logger.info("disposing");
        new Thread(() -> FileUtil.deleteTree(this.buildDirectory)).start();
        new Thread(() -> FileUtil.deleteTree(this.workingDirectory)).start();
        if (this.srcDirectory != null) {
            new Thread(() -> FileUtil.deleteTree(this.srcDirectory)).start();
        }
        this.logger.info("disposed");
        this.on_dispose.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeActionAndUpload(String action, String[] command, ProcessOutputListener log, ProcessOutputListener data, FileConsumer consumer) {
        boolean bl;
        block5: {
            File actionResultDirectory = null;
            try {
                this.logger.log(Level.INFO, "executing action " + action);
                actionResultDirectory = FileUtil.createTemporaryDirectory();
                this.logger.fine((this.srcDirectory != null ? "source in " + this.srcDirectory + ", " : "") + "working in directory " + this.workingDirectory + ", build in " + this.buildDirectory + ", storing action results in " + actionResultDirectory);
                command = ArraysUtil.append(String.class, command, this.buildDirectory.getAbsolutePath().replace("\\\\", "/").replace("\\", "/"));
                command = ArraysUtil.append(String.class, command, actionResultDirectory.getAbsolutePath().replace("\\\\", "/").replace("\\", "/"));
                this.logger.fine("using command " + Arrays.toString(command));
                int exit = ProcessExecutor.execute(this.workingDirectory, data, log, true, command);
                boolean success = exit == 0;
                this.logger.log(Level.INFO, "action " + (success ? "suceeded" : "failed") + ", uploading");
                consumer.consume(actionResultDirectory);
                this.logger.log(Level.INFO, "action finished");
                bl = success;
                if (actionResultDirectory == null) break block5;
            }
            catch (Throwable t) {
                boolean bl2;
                block6: {
                    try {
                        this.logger.log(Level.SEVERE, "unexpected error on executing action", t);
                        bl2 = false;
                        if (actionResultDirectory == null) break block6;
                    }
                    catch (Throwable throwable) {
                        if (actionResultDirectory != null) {
                            FileUtil.deleteTree(actionResultDirectory);
                        }
                        throw throwable;
                    }
                    FileUtil.deleteTree(actionResultDirectory);
                }
                return bl2;
            }
            FileUtil.deleteTree(actionResultDirectory);
        }
        return bl;
    }

    public void executeActionAndRememberResult(String project, long id, Capability capability, String action, String[] command) {
        block14: {
            File actionResultDirectory = null;
            try {
                boolean success;
                this.logger.log(Level.INFO, "executing action " + action);
                actionResultDirectory = this.storage.getRandomRememberFile();
                actionResultDirectory.mkdirs();
                this.logger.fine((this.srcDirectory != null ? "source in " + this.srcDirectory + ", " : "") + "working in directory " + this.workingDirectory + ", build in " + this.buildDirectory + ", storing action results in " + actionResultDirectory);
                final File logFile = this.storage.createRememberFile(action, ".log");
                final File dataFile = this.storage.createRememberFile(action, ".data");
                command = ArraysUtil.append(String.class, command, this.buildDirectory.getAbsolutePath().replace("\\\\", "/").replace("\\", "/"));
                command = ArraysUtil.append(String.class, command, actionResultDirectory.getAbsolutePath().replace("\\\\", "/").replace("\\", "/"));
                this.logger.fine("using command " + Arrays.toString(command));
                ProcessOutputListener logListener = new ProcessOutputListener(){
                    Writer out;
                    {
                        this.out = new FileWriter(logFile);
                    }

                    @Override
                    public void log(String line) throws IOException {
                        this.out.write(line + "\n");
                        this.out.flush();
                    }
                };
                ProcessOutputListener dataListener = new ProcessOutputListener(){
                    Writer out;
                    {
                        this.out = new FileWriter(dataFile);
                    }

                    @Override
                    public void log(String line) throws IOException {
                        this.out.write(line + "\n");
                        this.out.flush();
                    }
                };
                RememberedEntry rEntry = new RememberedEntry(project, id, action, capability, Arrays.toString(command), actionResultDirectory, false, logFile, dataFile);
                boolean rememberedFileWritten = false;
                int tries = 0;
                while (!rememberedFileWritten && tries < 10) {
                    try {
                        ++tries;
                        this.storage.appendRememberedEntry(rEntry);
                        this.logger.info("remembered file entry written");
                        rememberedFileWritten = true;
                    }
                    catch (IOException ex) {
                        if (tries < 10) {
                            this.logger.warning("remembered file entry could not be written, retrying in 60s");
                        } else {
                            this.logger.warning("remembered file entry could not be written, will not retry");
                        }
                        Thread.sleep(60000L);
                    }
                }
                int exit = ProcessExecutor.execute(this.workingDirectory, dataListener, logListener, true, command);
                boolean bl = success = exit == 0;
                if (rEntry.getSuccess() != success) {
                    rEntry.setSuccess(success);
                    rememberedFileWritten = false;
                    tries = 0;
                    while (!rememberedFileWritten && tries < 10) {
                        try {
                            ++tries;
                            boolean entryFound = this.storage.changeRememberedEntry(rEntry);
                            if (!entryFound) {
                                this.logger.warning("entry to change could not be found in remembered file!");
                            }
                            this.logger.info("remembered file entry written");
                            rememberedFileWritten = true;
                        }
                        catch (IOException ex) {
                            if (tries < 10) {
                                this.logger.warning("remembered file entry could not be edited, retrying in 60s");
                            } else {
                                this.logger.warning("remembered file entry could not be edited, will not retry");
                            }
                            Thread.sleep(60000L);
                        }
                    }
                }
                this.logger.info("action " + (success ? "suceeded" : "failed"));
                this.logger.info("action finished");
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "unexpected error on executing action", t);
                if (actionResultDirectory == null) break block14;
                FileUtil.deleteTree(actionResultDirectory);
            }
        }
    }
}

