/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class InterruptableSocket
extends Socket {
    private final boolean keepReadingOnTimeout;

    public InterruptableSocket(String host, int port, int timeout) throws UnknownHostException, IOException {
        super(host, port);
        this.keepReadingOnTimeout = timeout == 0;
        this.setSoTimeout(this.keepReadingOnTimeout ? 1000 : timeout);
    }

    @Override
    public InputStream getInputStream() throws IOException, SocketTimeoutException, InterruptedIOException {
        final InputStream inner = super.getInputStream();
        return new InputStream(){

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedIOException();
                        }
                        return inner.read(buf, off, len);
                    }
                    catch (SocketTimeoutException ste) {
                        if (!Thread.currentThread().isInterrupted()) continue;
                        throw new InterruptedIOException();
                        if (InterruptableSocket.this.keepReadingOnTimeout) continue;
                        throw ste;
                    }
                    break;
                }
            }

            @Override
            public int read() throws IOException {
                byte[] buf = new byte[1];
                return this.read(buf, 0, 1) >= 0 ? buf[0] : -1;
            }
        };
    }
}

