/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.stream.Stream;

public class ArraysUtil {
    private ArraysUtil() {
        throw new Error();
    }

    public static <T> T[] subarray(T[] array, int from, int to, IntFunction<T[]> toArray) {
        return Arrays.stream(array, from, to).toArray(toArray);
    }

    @SafeVarargs
    public static <T> T[] append(Class<T> clazz, T[] array, T ... elements) {
        return ArraysUtil.merge(clazz, array, elements);
    }

    @SafeVarargs
    public static <T> T[] merge(Class<T> clazz, T[] ... arrays) {
        return Arrays.stream(arrays).flatMap(array -> Arrays.stream(array)).toArray(l -> ArraysUtil.create(clazz, l));
    }

    public static <T> T[] create(Class<T> clazz, int length) {
        return (Object[])Array.newInstance(clazz, length);
    }

    public static <T> boolean contains(T[] haystack, T needle) {
        return haystack == null ? false : ((Stream)Arrays.stream(haystack).parallel()).anyMatch(straw -> straw.equals(needle));
    }

    public static boolean contains(long[] haystack, long needle) {
        return haystack == null ? false : Arrays.stream(haystack).parallel().anyMatch(straw -> straw == needle);
    }

    public static boolean contains(int[] haystack, int needle) {
        return haystack == null ? false : Arrays.stream(haystack).parallel().anyMatch(straw -> straw == needle);
    }

    public static <T> int indexOf(T[] haystack, T needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] haystack, long needle) {
        for (int i = 0; i < haystack.length; ++i) {
            if (haystack[i] != needle) continue;
            return i;
        }
        return -1;
    }
}

