/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared.process;

import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessOutputListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ProcessOutputRedirector {
    private final InputStream in;
    private final ProcessOutputListener out;
    private final Thread worker;

    public ProcessOutputRedirector(InputStream in, ProcessOutputListener out) {
        this.in = in;
        this.out = out;
        this.worker = new Thread(this::run);
        this.worker.start();
    }

    private void run() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.in));){
            String line = in.readLine();
            while (line != null) {
                this.out.log(line);
                line = in.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void join() throws InterruptedException {
        this.worker.join();
    }
}

