/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared.io;

import at.jku.ssw.mevss.cerberus.ci.shared.process.NullProcessOutputListener;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;

public class FileUtil {
    private static File TMP_DIR;
    private static String TMP_PREFIX;
    private static String TMP_POSTFIX;

    public static boolean deleteTree(File file) {
        File[] children;
        boolean ok = file.isDirectory() ? ((children = file.listFiles()) != null ? Arrays.stream(children).map(FileUtil::deleteTree).allMatch(k -> k) && file.delete() : false) : file.delete();
        if (!ok) {
            try {
                ok = ProcessExecutor.execute(new File("."), new NullProcessOutputListener(), new NullProcessOutputListener(), false, "rm", "-rf", file.getAbsolutePath()) == 0;
            }
            catch (IOException | InterruptedException e) {
                ok = false;
            }
        }
        return ok;
    }

    public static File createTemporaryDirectory() throws IOException {
        File dir = FileUtil.createTemporaryFile();
        if (!dir.delete()) {
            throw new IOException();
        }
        if (!dir.mkdirs()) {
            throw new IOException();
        }
        return dir;
    }

    public static File createTemporaryFile() throws IOException {
        return File.createTempFile(TMP_PREFIX, TMP_POSTFIX, TMP_DIR).getAbsoluteFile();
    }

    public static File relativize(File file, File base) {
        return new File(base.toURI().relativize(file.toURI()).getPath());
    }

    public static String readSilently(File file) {
        try {
            return FileUtil.read(file);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            StringBuilder string2 = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                string2.append(line);
                string2.append('\n');
                line = in.readLine();
            }
            String string = string2.toString().substring(0, string2.length() - (string2.length() > 0 ? 1 : 0));
            return string;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    public static void write(File file, String content) throws IOException {
        try (FileWriter out = new FileWriter(file);){
            out.write(content);
        }
    }

    public static <T> T readPropertyValueSilently(File file, String key, boolean trim, Function<String, T> parser, T backup) {
        try {
            return FileUtil.readPropertyValue(file, key, trim, parser, backup);
        }
        catch (IOException e) {
            return backup;
        }
    }

    public static <T> T readPropertyValue(File haystack, String needle, boolean trim, Function<String, T> parser, T backup) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(haystack));){
            String line = in.readLine();
            while (line != null) {
                if (trim) {
                    line = line.trim();
                }
                if (line.length() > 0 && !line.startsWith("%") && line.contains("=")) {
                    int splitter = line.indexOf("=");
                    String straw = line.substring(0, splitter);
                    if (trim) {
                        straw = straw.trim();
                    }
                    if (straw.equals(needle)) {
                        String value = line.substring(splitter + 1, line.length());
                        if (trim) {
                            value = value.trim();
                        }
                        T t = parser.apply(value);
                        return t;
                    }
                }
                line = in.readLine();
            }
        }
        return backup;
    }

    private FileUtil() {
        throw new Error();
    }

    public static boolean deleteFilesInTree(File file, String[] keepFileEndings) {
        try {
            FileUtil.deleteFilesInTree0(file, keepFileEndings);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static void deleteFilesInTree0(File file, String[] keepFileEndings) throws RuntimeException {
        try {
            if (file.isDirectory()) {
                Files.newDirectoryStream(file.toPath()).forEach(x -> FileUtil.deleteFilesInTree0(x.toFile(), keepFileEndings));
                if (file.listFiles().length == 0 && !file.delete()) {
                    throw new IOException(file.toString());
                }
            } else if (!Stream.of(keepFileEndings).anyMatch(ending -> file.getAbsolutePath().endsWith((String)ending)) && !file.delete()) {
                throw new IOException(file.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        TMP_PREFIX = "cerberus";
        TMP_POSTFIX = ".tmp";
        String override = System.getProperty("java.io.tmpdir.ci.override");
        if (override != null) {
            File tmp = new File(override);
            if (!tmp.exists() && !tmp.isAbsolute()) {
                tmp = new File(System.getProperty("user.home") + File.separator + tmp);
            }
            if (tmp.exists()) {
                if (!tmp.isDirectory()) throw new ExceptionInInitializerError();
                TMP_DIR = tmp;
                for (File child : TMP_DIR.listFiles()) {
                    Thread thread = new Thread(() -> FileUtil.deleteTree(child), child + " Deleter");
                    thread.setDaemon(true);
                    thread.start();
                }
                return;
            } else {
                TMP_DIR = null;
            }
            return;
        } else {
            TMP_DIR = null;
        }
    }
}

