/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.storage;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import at.jku.ssw.mevss.cerberus.ci.master.storage.StorageListener;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.io.ZipUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class Storage {
    private final File base;
    private final BuildEnvironment[] envs;
    private final int capacity;
    private final int history;
    private final List<StorageListener> listeners = Collections.synchronizedList(new CopyOnWriteArrayList());
    private static final String[] KEEP_FILES_TEST = new String[]{".log", ".result", ".result.best", ".result.all", ".result.global", ".err", ".csv", ".out"};
    private static final String[] KEEP_FILES_PERFORMANCE = ArraysUtil.append(String.class, KEEP_FILES_TEST, ".zip");

    public Storage(File base, BuildEnvironment[] envs, int capacity, int history) throws IOException {
        this.base = base;
        this.envs = envs;
        this.capacity = capacity;
        this.history = history;
        base.mkdirs();
        this.repair();
        this.cleanup();
    }

    public BuildEnvironment[] getEnvironments() {
        return (BuildEnvironment[])this.envs.clone();
    }

    public void addListener(StorageListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeListener(StorageListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public File getBase() {
        return this.base;
    }

    public File getDirectory(long id) {
        File result = new File(this.getBase() + File.separator + id);
        result.mkdirs();
        return result;
    }

    private File getMetaFile(long id) {
        return new File(this.getDirectory(id) + File.separator + "about");
    }

    private File getRevisionFile(long id) {
        return new File(this.getDirectory(id) + File.separator + "revisions");
    }

    private File getEnvDirectory(long id, BuildEnvironment env) {
        return this.getEnvDirectory(id, env, true);
    }

    private File getEnvDirectory(long id, BuildEnvironment env, boolean create) {
        File result = new File(this.getDirectory(id) + File.separator + Storage.toString(env));
        if (create) {
            result.mkdir();
        }
        return result;
    }

    private File getEnvMetaFile(long id, BuildEnvironment env) {
        return new File(this.getEnvDirectory(id, env) + File.separator + "about");
    }

    public File getBuildDirectory(long id, BuildEnvironment env, boolean create) {
        File result = new File(this.getEnvDirectory(id, env) + File.separator + "build");
        if (create) {
            result.mkdir();
        }
        return result;
    }

    public File getBuildLogFile(long id, BuildEnvironment env) {
        return new File(this.getEnvDirectory(id, env) + File.separator + "build.log");
    }

    private File getTestsDirectory(long id, BuildEnvironment env) {
        File result = new File(this.getEnvDirectory(id, env) + File.separator + "tests");
        result.mkdirs();
        return result;
    }

    public File getTestDirectory(long id, BuildEnvironment env, String name, boolean create) {
        File result = new File(this.getTestsDirectory(id, env) + File.separator + name);
        if (create) {
            result.mkdir();
        }
        return result;
    }

    public File getTestLogFile(long id, BuildEnvironment env, String name) {
        return new File(this.getTestsDirectory(id, env) + File.separator + name + ".log");
    }

    public File getTestDataFile(long id, BuildEnvironment env, String name) {
        return new File(this.getTestsDirectory(id, env) + File.separator + name + ".data");
    }

    private static String toString(BuildEnvironment env) {
        return env.os + "_" + env.arch + "_" + env.length;
    }

    public void writeNewBuildMeta(long id, Map<String, Long> revisions, String name, BuildEnvironment[] envs, String[] functionalTests, String[] performanceTests) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getMetaFile(id)));){
            writer.write("time=" + id + "\n");
            writer.write("name=" + name + "\n");
            writer.write("tests=" + this.getStringList(functionalTests) + "\n");
            writer.write("performances=" + this.getStringList(performanceTests) + "\n");
        }
        writer = new BufferedWriter(new FileWriter(this.getRevisionFile(id)));
        var9_8 = null;
        try {
            for (String repoName : revisions.keySet()) {
                writer.write(repoName + "=" + String.valueOf(revisions.get(repoName)) + "\n");
            }
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var9_8 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var9_8.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
        for (BuildEnvironment env : envs) {
            this.getEnvDirectory(id, env, true);
        }
        for (StorageListener l : this.listeners) {
            for (BuildEnvironment env : envs) {
                l.added(id, env);
            }
        }
    }

    private String getStringList(String[] tests) {
        StringBuilder string = new StringBuilder();
        for (int i = 0; i < tests.length; ++i) {
            if (i > 0) {
                string.append(",");
            }
            string.append(tests[i]);
        }
        return string.toString();
    }

    public void writeBuildEntry(long id, BuildEnvironment env, boolean success) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getEnvMetaFile(id, env), true));){
            writer.write("build=" + success + "\n");
        }
        this.fireBuildChanged(id, env);
    }

    public void writeActionEntry(long id, BuildEnvironment env, Capability capability, String action, boolean success) throws IOException {
        switch (capability) {
            case PERFORMANCE_TEST: {
                this.writePerformanceTestEntry(id, env, action, success);
                break;
            }
            case FUNCTIONAL_TEST: {
                this.writeTestEntry(id, env, action, success);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void writeTestEntry(long id, BuildEnvironment env, String name, boolean success) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getEnvMetaFile(id, env), true));){
            writer.write("test_" + name + "=" + success + "\n");
        }
        this.fireBuildChanged(id, env);
    }

    public void writePerformanceTestEntry(long id, BuildEnvironment env, String name, boolean success) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getEnvMetaFile(id, env), true));){
            writer.write("performance_" + name + "=" + success + "\n");
        }
        this.fireBuildChanged(id, env);
    }

    private void fireBuildChanged(long id, BuildEnvironment env) {
        for (StorageListener l : this.listeners) {
            l.changed(id, env);
        }
    }

    public long[] getBuilds() {
        return Arrays.stream(this.base.listFiles()).map(f -> f.getName()).sorted().mapToLong(n -> Long.parseLong(n)).toArray();
    }

    public String getName(long id) throws IOException {
        return Storage.getValue(this.getMetaFile(id), "name", value -> value);
    }

    public Date getTime(long id) throws IOException {
        return Storage.getValue(this.getMetaFile(id), "time", value -> new Date(Long.parseLong(value)));
    }

    public BuildEnvironment[] getEnvironments(long id) {
        return (BuildEnvironment[])Arrays.stream(this.envs).filter(env -> this.getEnvDirectory(id, (BuildEnvironment)env, false).exists()).toArray(BuildEnvironment[]::new);
    }

    public String[] getFunctionalTests(long id) throws IOException {
        String[] tests = Storage.getValue(this.getMetaFile(id), "tests", value -> value.split(","));
        if (tests == null) {
            tests = new String[]{};
        }
        return (String[])Arrays.stream(tests).filter(test -> test.length() > 0).toArray(String[]::new);
    }

    public String[] getPerformanceTests(long id) throws IOException {
        String[] tests = Storage.getValue(this.getMetaFile(id), "performances", value -> value.split(","));
        if (tests == null) {
            tests = new String[]{};
        }
        return (String[])Arrays.stream(tests).filter(test -> test.length() > 0).toArray(String[]::new);
    }

    public Map<String, Long> getRevisions(long id) throws IOException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        try (BufferedReader in = new BufferedReader(new FileReader(this.getRevisionFile(id)));){
            String line = in.readLine();
            while (line != null) {
                int index = line.indexOf("=");
                String key = line.substring(0, index);
                String value = line.substring(index + 1, line.length());
                String repository = key;
                long revision = Long.parseLong(value);
                result.put(repository, revision);
                line = in.readLine();
            }
        }
        return result;
    }

    public Boolean getBuildResult(long id, BuildEnvironment env) throws IOException {
        return Storage.getValue(this.getEnvMetaFile(id, env), "build", value -> value.length() != 0 ? Boolean.valueOf(Boolean.parseBoolean(value)) : null);
    }

    public Boolean getFunctionalTestResult(long id, BuildEnvironment env, String name) throws IOException {
        return Storage.getValue(this.getEnvMetaFile(id, env), "test_" + name, value -> value.length() != 0 ? Boolean.valueOf(Boolean.parseBoolean(value)) : null);
    }

    public Boolean getPerformanceTestResult(long id, BuildEnvironment env, String name) throws IOException {
        return Storage.getValue(this.getEnvMetaFile(id, env), "performance_" + name, value -> value.length() != 0 ? Boolean.valueOf(Boolean.parseBoolean(value)) : null);
    }

    private static <T> T getValue(File file, String key, Function<String, T> parser) throws IOException {
        try {
            return FileUtil.readPropertyValue(file, key, false, parser, null);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    private void repair() {
        for (long id : this.getBuilds()) {
            for (BuildEnvironment env : this.getEnvironments(id)) {
                boolean damaged;
                try {
                    damaged = this.getBuildResult(id, env) == null;
                }
                catch (IOException e) {
                    damaged = true;
                }
                if (!damaged) continue;
                FileUtil.deleteTree(this.getEnvDirectory(id, env));
            }
            if (this.getEnvironments(id).length != 0) continue;
            FileUtil.deleteTree(this.getDirectory(id));
        }
    }

    public void cleanup() {
        int index;
        long[] builds;
        if (this.capacity >= 0) {
            builds = this.getBuilds();
            for (index = 0; index < builds.length - this.capacity; ++index) {
                this.clear(builds[index]);
            }
        }
        if (this.history >= 0) {
            builds = this.getBuilds();
            for (index = 0; index < builds.length - this.history; ++index) {
                this.delete(builds[index]);
            }
        }
    }

    private void delete(long id) {
        for (BuildEnvironment env : this.getEnvironments(id)) {
            this.listeners.stream().forEach(l -> l.removed(id, env));
        }
        FileUtil.deleteTree(this.getDirectory(id));
    }

    private void clear(long id) {
        for (BuildEnvironment env : this.getEnvironments(id)) {
            this.clearAndArchive(this.getBuildDirectory(id, env, false), new String[0]);
            try {
                for (String test : this.getFunctionalTests(id)) {
                    this.clearAndArchive(this.getTestDirectory(id, env, test, false), KEEP_FILES_TEST);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                for (String test : this.getPerformanceTests(id)) {
                    this.clearAndArchive(this.getPerformanceDirectory(id, env, test, false), KEEP_FILES_PERFORMANCE);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void clearAndArchive(File file, String ... endings) {
        if (file.isDirectory()) {
            FileUtil.deleteFilesInTree(file, endings);
            ZipUtil.toZip(file);
        }
    }

    public String toString() {
        try {
            StringBuilder string = new StringBuilder();
            for (long build : this.getBuilds()) {
                string.append(build + ":\n");
                for (BuildEnvironment env : this.envs) {
                    string.append("\t" + env + ": " + this.getBuildResult(build, env) + "\n");
                }
            }
            return string.toString();
        }
        catch (IOException e) {
            return "error reading data";
        }
    }

    public File getActionDirectory(long id, BuildEnvironment env, Capability responsibility, String action, boolean create) {
        switch (responsibility) {
            case FUNCTIONAL_TEST: {
                return this.getTestDirectory(id, env, action, create);
            }
            case PERFORMANCE_TEST: {
                return this.getPerformanceDirectory(id, env, action, create);
            }
        }
        return null;
    }

    private File getPerformanceDirectory(long id, BuildEnvironment env) {
        File result = new File(this.getEnvDirectory(id, env) + File.separator + "performance");
        result.mkdirs();
        return result;
    }

    public File getPerformanceDirectory(long id, BuildEnvironment env, String action, boolean create) {
        File result = new File(this.getPerformanceDirectory(id, env) + File.separator + action);
        if (create) {
            result.mkdir();
        }
        return result;
    }

    public File getActionLogFile(long id, BuildEnvironment env, Capability responsibility, String action) {
        switch (responsibility) {
            case FUNCTIONAL_TEST: {
                return this.getTestLogFile(id, env, action);
            }
            case PERFORMANCE_TEST: {
                return this.getPerformanceLogFile(id, env, action);
            }
        }
        return null;
    }

    public File getPerformanceLogFile(long id, BuildEnvironment env, String name) {
        return new File(this.getPerformanceDirectory(id, env) + File.separator + name + ".log");
    }

    public File getPerformanceDataFile(long id, BuildEnvironment env, String name) {
        return new File(this.getPerformanceDirectory(id, env) + File.separator + name + ".data");
    }

    public File getActionDataFile(long id, BuildEnvironment env, String action, Capability responsibility) throws FileNotFoundException {
        switch (responsibility) {
            case FUNCTIONAL_TEST: {
                return this.getTestDataFile(id, env, action);
            }
            case PERFORMANCE_TEST: {
                return this.getPerformanceDataFile(id, env, action);
            }
        }
        throw new FileNotFoundException("No data file defined for given responsibility");
    }
}

