/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.schedule;

import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import java.util.Date;

public abstract class Task
implements Comparable<Task> {
    private final String name;
    private final BuildEnvironment[] envs;
    private final String[] actions;
    private final boolean deploy;

    public Task(String name, BuildEnvironment[] envs, String[] actions, boolean deploy) {
        this.name = name;
        this.envs = envs;
        this.actions = actions;
        this.deploy = deploy;
    }

    public abstract Type getType();

    public String getName() {
        return this.name;
    }

    public abstract long getTime();

    public BuildEnvironment[] getEnvs() {
        return this.envs;
    }

    public String[] getActions() {
        return this.actions;
    }

    public boolean includesDeploy() {
        return this.deploy;
    }

    @Override
    public int compareTo(Task that) {
        int diff = (int)Math.signum(this.getTime() - that.getTime());
        if (diff != 0) {
            return diff;
        }
        return this.getType().ordinal() - that.getType().ordinal();
    }

    public String toString() {
        return this.name + " @ " + new Date(this.getTime()).toString();
    }

    public static enum Type {
        SPECIAL(false),
        MONTHLY(true),
        WEEKLY(true),
        DAILY(true);

        public final boolean isReoccuring;

        private Type(boolean isReoccouring) {
            this.isReoccuring = isReoccouring;
        }
    }
}

