/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.schedule;

import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigSchedule;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.DailyTask;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.MonthlyTask;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.ReoccuringTask;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.Task;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.WeeklyTask;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class Scheduler {
    private final Object lock = new Object();
    private final List<Task> queue = new LinkedList<Task>();

    public Scheduler(ReoccuringTask[] tasks) {
        this.queue.addAll(Arrays.asList(tasks));
        this.reschedule();
    }

    public Scheduler(ConfigSchedule[] schedules) {
        this(Scheduler.createTasks(schedules));
    }

    private static ReoccuringTask[] createTasks(ConfigSchedule[] schedules) {
        return (ReoccuringTask[])Arrays.stream(schedules).map(s -> Scheduler.createTask(s)).toArray(ReoccuringTask[]::new);
    }

    private static ReoccuringTask createTask(ConfigSchedule schedule) {
        switch (schedule.type) {
            case "daily": {
                return new DailyTask(schedule.name, schedule.getActions(), schedule.deploy, schedule.hours, schedule.minutes, 0);
            }
            case "weekly": {
                return new WeeklyTask(schedule.name, schedule.getActions(), schedule.deploy, schedule.day_of_week, schedule.hours, schedule.minutes, 0);
            }
            case "monthly": {
                return new MonthlyTask(schedule.name, schedule.getActions(), schedule.deploy, schedule.day_of_month, schedule.day_of_week, schedule.hours, schedule.minutes, 0);
            }
        }
        throw new IllegalArgumentException("Illegal schedule type: " + schedule.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSpecialTask() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.stream().anyMatch(t -> t.getType() == Task.Type.SPECIAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task next() {
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() > 0) {
                return this.queue.remove(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Task task) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(task);
            Collections.sort(this.queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule() {
        Object object = this.lock;
        synchronized (object) {
            this.queue.stream().filter(t -> t.getType().isReoccuring).map(t -> (ReoccuringTask)t).forEach(t -> t.reschedule());
            Collections.sort(this.queue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            StringBuilder string = new StringBuilder();
            for (Task task : this.queue) {
                string.append(new Date(task.getTime()) + " " + task.getName() + "\n");
            }
            return string.toString();
        }
    }
}

