/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.repository;

import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.RepositoryException;
import at.jku.ssw.mevss.cerberus.ci.shared.MutableInteger;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessExecutor;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessOutputListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class SubversionRepository
extends Repository {
    private static final String EXECUTABLE = "/usr/bin/svn";
    private final String url;
    private final String user;
    private final String pwd;

    public SubversionRepository(File location, String name, String url, String map, String branch) {
        super(name, location);
        this.url = url.substring(url.indexOf(64) + 1, url.length());
        this.user = url.substring(0, url.indexOf(58));
        this.pwd = url.substring(url.indexOf(58) + 1, url.indexOf(64));
    }

    @Override
    public String getHiddenFilePrefix() {
        return ".svn";
    }

    @Override
    public long getRevisionNumber(Logger logger) throws RepositoryException {
        try {
            RevisionParser parser = new RevisionParser();
            ProcessExecutor.executeAndCheck(this.getLocation(), parser, parser, true, EXECUTABLE, "--username", this.user, "--password", this.pwd, "info", "-r", "HEAD");
            return parser.revision;
        }
        catch (IOException | InterruptedException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public boolean update(Logger logger) throws RepositoryException {
        try {
            if (this.getLocation().exists()) {
                MutableInteger lines = new MutableInteger();
                ProcessExecutor.executeAndCheck(this.getLocation(), __ -> ++lines.value, __ -> ++lines.value, true, EXECUTABLE, "--username", this.user, "--password", this.pwd, "update", ".");
                return lines.value > 2;
            }
            this.getLocation().mkdirs();
            ProcessExecutor.executeAndCheck(this.getLocation(), true, EXECUTABLE, "--username", this.user, "--password", this.pwd, "checkout", this.url, ".");
            this.update(logger);
            return true;
        }
        catch (IOException | InterruptedException e) {
            FileUtil.deleteTree(this.getLocation());
            throw new RepositoryException(e);
        }
    }

    @Override
    public Change[] getChanges(long revision, Logger __) throws RepositoryException {
        try {
            DiffParser parser = new DiffParser(revision);
            ProcessExecutor.executeAndCheck(this.getLocation(), parser, parser, true, EXECUTABLE, "--username", this.user, "--password", this.pwd, "-r", String.valueOf(revision), "--diff", "log");
            return parser.changes.toArray(new Change[parser.changes.size()]);
        }
        catch (IOException | InterruptedException e) {
            throw new RepositoryException(e);
        }
    }

    private class DiffParser
    implements ProcessOutputListener {
        private final long revision;
        private final List<Change> changes = new ArrayList<Change>();
        private int state = 0;
        private String author = null;
        private int messageLines = 0;
        private String[] message = null;
        private String file = null;
        private List<Integer> changedLines = null;
        private StringBuilder diff = null;

        public DiffParser(long revision) {
            this.revision = revision;
        }

        @Override
        public void log(String line) throws IOException {
            switch (this.state) {
                case 0: {
                    if (!line.startsWith("r")) break;
                    int start = line.indexOf(124) + 2;
                    int end = line.indexOf(124, start) - 1;
                    this.author = line.substring(start, end);
                    start = line.lastIndexOf(124) + 2;
                    end = line.indexOf(32, start);
                    this.messageLines = Integer.parseInt(line.substring(start, end)) + 2;
                    this.message = new String[this.messageLines];
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.message[this.message.length - this.messageLines--] = line;
                    if (this.messageLines != 0) break;
                    this.state = 2;
                    break;
                }
                case 4: {
                    if (line.startsWith("+") || line.startsWith("-") || line.startsWith(" ")) {
                        this.diff.append(line + "\n");
                        break;
                    }
                    this.flush();
                    this.state = 2;
                }
                case 2: {
                    String INTRO = "Index: ";
                    if (line.startsWith("Index: ")) {
                        this.file = line.substring("Index: ".length());
                        this.state = 3;
                        break;
                    }
                    this.flush();
                    this.state = 3;
                }
                case 3: {
                    String marker = "@@";
                    line = line.trim();
                    if (!line.startsWith("@@") || !line.endsWith("@@")) break;
                    this.changedLines = new ArrayList<Integer>();
                    line = line.substring("@@".length(), line.length() - "@@".length()).trim();
                    for (String token : line.split(" ")) {
                        int c;
                        int l;
                        int splitter = token.indexOf(",");
                        if (splitter >= 0) {
                            l = Math.abs(Integer.parseInt(token.substring(0, splitter)));
                            c = Integer.parseInt(token.substring(splitter + 1, token.length()));
                        } else {
                            l = Math.abs(Integer.parseInt(token));
                            c = 1;
                        }
                        while (c > 0) {
                            this.changedLines.add(l++);
                            --c;
                        }
                    }
                    this.diff = new StringBuilder();
                    this.state = 4;
                }
            }
        }

        private void flush() {
            this.changes.add(new Change(SubversionRepository.this.getName(), this.revision, this.author, this.file, Stream.of(this.message).reduce("", (l1, l2) -> l1 + "\n" + l2).trim(), this.changedLines.stream().mapToInt(i -> i).toArray(), this.diff.toString()));
            this.diff = new StringBuilder();
        }
    }

    private static class RevisionParser
    implements ProcessOutputListener {
        public long revision;

        private RevisionParser() {
        }

        @Override
        public void log(String line) throws IOException {
            String HEADER = "Revision:";
            if (line.startsWith("Revision:")) {
                this.revision = Integer.parseInt(line.substring("Revision:".length()).trim());
            }
        }
    }
}

