/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.repository;

import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.RepositoryException;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.process.NullProcessOutputListener;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessExecutor;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessOutputListener;
import at.jku.ssw.mevss.cerberus.ci.shared.process.StoringProcessOutputListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class MercurialRepository
extends Repository {
    private static final String EXECUTABLE = "/usr/bin/hg";
    private static final Set<String> DOWNLOADING = new HashSet<String>();
    private final String name;
    private final String url;
    private final String map;
    private final String branch;
    private static final String LOG_SEP = "%";
    private static final String LOG_TEMPLATE = "{rev}%{author|person}%{files}%{desc}\n";

    public MercurialRepository(File location, String name, String url, String map, String branch) {
        super(name, location);
        this.name = name != null ? name : url.substring(url.lastIndexOf(47) + 1);
        this.url = url;
        this.map = map;
        this.branch = branch != null ? branch : "default";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHiddenFilePrefix() {
        return ".hg";
    }

    @Override
    public long getRevisionNumber(Logger logger) {
        try {
            StoringProcessOutputListener listener = new StoringProcessOutputListener();
            ProcessExecutor.executeAndCheck(this.getLocation(), listener, listener, true, EXECUTABLE, "log", "--branch", this.branch, "-l", "1", "--template", "{rev}");
            return Long.parseLong(listener.toString().trim());
        }
        catch (IOException | InterruptedException e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(Logger logger) throws RepositoryException {
        File location = this.getLocation();
        if (!location.exists()) {
            try {
                location.mkdirs();
                try {
                    this.startDownload();
                    ProcessExecutor.executeAndCheck(this.getLocation(), new NullProcessOutputListener(), new NullProcessOutputListener(), true, EXECUTABLE, "clone", "--insecure", this.url, ".");
                }
                finally {
                    this.stopDownload();
                }
                this.update(logger);
                return true;
            }
            catch (Throwable e) {
                FileUtil.deleteTree(location);
                throw new RepositoryException(e);
            }
        }
        try {
            long oldRevision = this.getRevisionNumber(logger);
            StoringProcessOutputListener listener = new StoringProcessOutputListener();
            try {
                this.startDownload();
                ProcessExecutor.executeAndCheck(this.getLocation(), new NullProcessOutputListener(), new NullProcessOutputListener(), true, EXECUTABLE, "pull", "--insecure", "-R", "./");
                ProcessExecutor.executeAndCheck(this.getLocation(), listener, listener, true, EXECUTABLE, "update", "--clean", "-R", "./", this.branch);
            }
            finally {
                this.stopDownload();
            }
            if (MercurialRepository.parseChangeCount(listener.toString().trim()) > 0) {
                if (this.map != null && this.map.length() > 0) {
                    long newRevision = this.getRevisionNumber(logger);
                    for (long revision = oldRevision + 1L; revision <= newRevision; ++revision) {
                        if (this.getSimpleChanges(revision, logger).length <= 0) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            throw new RepositoryException(e);
        }
    }

    private static int parseChangeCount(String input) {
        int totalChanges = 0;
        for (int i = 0; i < input.length(); ++i) {
            int changes = 0;
            while (Character.isDigit(input.charAt(i)) && i < input.length()) {
                int digit = input.charAt(i++) - 48;
                changes = changes * 10 + digit;
            }
            totalChanges += changes;
        }
        return totalChanges;
    }

    @Override
    public Change[] getChanges(long revision, Logger logger) throws RepositoryException {
        try {
            Change[] changes = this.getSimpleChanges(revision, logger);
            for (int i = 0; i < changes.length; ++i) {
                Change change = changes[i];
                DiffParser parser = this.getChange(revision, change.file, logger);
                int[] lines = parser.lines.stream().distinct().sorted().mapToInt(l -> l).toArray();
                changes[i] = new Change(change.repository, change.revision, change.author, this.map != null ? change.file.substring(this.map.length()) : change.file, change.message, lines, parser.string.toString());
            }
            return changes;
        }
        catch (IOException | InterruptedException e) {
            throw new RepositoryException(e);
        }
    }

    private Change[] getSimpleChanges(long revision, Logger logger) throws IOException, InterruptedException {
        LogParser logListener = new LogParser();
        ProcessExecutor.executeAndCheck(this.getLocation(), logListener, logListener, true, EXECUTABLE, "log", "--branch", this.branch, "--rev", String.valueOf(revision) + ":" + String.valueOf(revision), "--template", LOG_TEMPLATE);
        return (Change[])logListener.changes.stream().filter(c -> this.map == null || c.file.startsWith(this.map)).toArray(Change[]::new);
    }

    private DiffParser getChange(long revision, String file, Logger logger) throws IOException, InterruptedException {
        DiffParser parser = new DiffParser();
        ProcessExecutor.executeAndCheck(this.getLocation(), parser, parser, true, EXECUTABLE, "diff", "-c", String.valueOf(revision), file);
        return parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDownload() throws InterruptedException {
        Set<String> set = DOWNLOADING;
        synchronized (set) {
            while (DOWNLOADING.contains(this.url)) {
                DOWNLOADING.wait();
            }
            DOWNLOADING.add(this.url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDownload() {
        Set<String> set = DOWNLOADING;
        synchronized (set) {
            DOWNLOADING.remove(this.url);
            DOWNLOADING.notifyAll();
        }
    }

    private static class DiffParser
    implements ProcessOutputListener {
        private final List<Integer> lines = new ArrayList<Integer>();
        private final StringBuilder string = new StringBuilder();

        private DiffParser() {
        }

        @Override
        public synchronized void log(String line) {
            this.string.append(line);
            this.string.append("\n");
            String marker = "@@";
            line = line.trim();
            if (line.startsWith("@@") && line.endsWith("@@")) {
                line = line.substring("@@".length(), line.length() - "@@".length()).trim();
                for (String token : line.split(" ")) {
                    int c;
                    int l;
                    int splitter = token.indexOf(",");
                    if (splitter >= 0) {
                        l = Math.abs(Integer.parseInt(token.substring(0, splitter)));
                        c = Integer.parseInt(token.substring(splitter + 1, token.length()));
                    } else {
                        l = Math.abs(Integer.parseInt(token));
                        c = 1;
                    }
                    while (c > 0) {
                        this.lines.add(l++);
                        --c;
                    }
                }
            }
        }
    }

    private class LogParser
    implements ProcessOutputListener {
        private final List<Change> changes = new ArrayList<Change>();

        private LogParser() {
        }

        @Override
        public void log(String line) throws IOException {
            String[] tokens = line.split(MercurialRepository.LOG_SEP);
            int revision = Integer.parseInt(tokens[0]);
            String author = tokens[1];
            String[] files = tokens[2].split(" ");
            String message = tokens[3];
            for (String file : files) {
                this.changes.add(new Change(MercurialRepository.this.getName(), revision, author, file, message));
            }
        }
    }
}

