/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.repository;

import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.RepositoryException;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.process.NullProcessOutputListener;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessExecutor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

public class DirectoryRepository
extends Repository {
    private final File src;

    public DirectoryRepository(File location, String name, File src) {
        super(name, location);
        this.src = src;
    }

    @Override
    public String getHiddenFilePrefix() {
        return null;
    }

    @Override
    public long getRevisionNumber(Logger __) {
        return this.getLastModified(this.src.listFiles());
    }

    private long getLastModified(File[] files) {
        return Arrays.stream(files).mapToLong(f -> this.getLastModified((File)f)).max().orElse(0L);
    }

    private long getLastModified(File file) {
        if (file.isDirectory()) {
            return this.getLastModified(file.listFiles());
        }
        return file.lastModified();
    }

    @Override
    public boolean update(Logger logger) throws RepositoryException {
        try {
            if (!this.src.exists()) {
                throw new FileNotFoundException(this.src.toString());
            }
            this.getLocation().mkdirs();
            return this.updateContent(this.src, this.getLocation(), logger);
        }
        catch (Throwable t) {
            throw new RepositoryException(t);
        }
    }

    private boolean updateContent(File src, File dest, Logger logger) throws IOException, InterruptedException {
        String[] subDirs;
        String[] srcs = (String[])Arrays.stream(src.listFiles()).map(s -> s.getName()).toArray(String[]::new);
        String[] dests = (String[])Arrays.stream(dest.listFiles()).map(d -> d.getName()).toArray(String[]::new);
        String[] addeds = (String[])Arrays.stream(srcs).filter(s -> !ArraysUtil.contains(dests, s)).toArray(String[]::new);
        String[] removeds = (String[])Arrays.stream(dests).filter(d -> !ArraysUtil.contains(srcs, d)).toArray(String[]::new);
        String[] changeds = (String[])Arrays.stream(srcs).filter(s -> ArraysUtil.contains(dests, s)).filter(n -> new File(src + File.separator + n).lastModified() > new File(dest + File.separator + n).lastModified()).toArray(String[]::new);
        for (String added : addeds) {
            this.copy(new File(src + File.separator + added), new File(dest + File.separator + added), logger);
        }
        for (String removed : removeds) {
            FileUtil.deleteTree(new File(dest + File.separator + removed));
        }
        for (String changed : changeds) {
            this.copy(new File(src + File.separator + changed), new File(dest + File.separator + changed), logger);
        }
        boolean change = addeds.length > 0 || removeds.length > 0 || changeds.length > 0;
        boolean innerChange = false;
        for (String subDir : subDirs = (String[])Arrays.stream(src.listFiles()).filter(c -> c.isDirectory()).map(c -> c.getName()).toArray(String[]::new)) {
            File s2 = new File(src + File.separator + subDir);
            File d2 = new File(dest + File.separator + subDir);
            innerChange |= this.updateContent(s2, d2, logger);
        }
        return change || innerChange;
    }

    private void copy(File src, File dest, Logger logger) throws IOException, InterruptedException {
        ProcessExecutor.execute(this.getLocation(), new NullProcessOutputListener(), new NullProcessOutputListener(), true, "cp", "-v", "-r", "-u", src.getAbsolutePath(), dest.getAbsolutePath());
    }

    @Override
    public Change[] getChanges(long revision, Logger __) {
        return null;
    }
}

