/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.repository;

import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.RepositoryException;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.updater.Updater;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class CerberusRepository
extends Repository {
    private final String url;
    private final Updater updater;

    public CerberusRepository(File location, String name, String url) {
        super(name, location);
        this.url = url;
        this.updater = new Updater(name, location);
    }

    @Override
    public String getHiddenFilePrefix() {
        return ".cerberus";
    }

    @Override
    public long getRevisionNumber(Logger __) throws RepositoryException {
        try {
            return this.updater.getRevisionNumber();
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public boolean update(Logger __) throws RepositoryException {
        try {
            if (this.getLocation().exists()) {
                return this.updater.update();
            }
            this.updater.checkout(this.url);
            this.updater.update();
            return true;
        }
        catch (Throwable e) {
            FileUtil.deleteTree(this.getLocation());
            throw new RepositoryException(e);
        }
    }

    @Override
    public Change[] getChanges(long __, Logger ___) {
        return null;
    }
}

