/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.mail;

import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.shared.PropertiesUtil;
import com.sun.mail.smtp.SMTPTransport;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Notification {
    private final Logger logger;
    private final String name;
    private final String host;
    private final Map<String, String> addresses;

    public Notification(String name, String host, File config) throws IOException {
        this.logger = Logger.getLogger("cerberus.notification." + name);
        this.name = name;
        this.host = host;
        this.addresses = PropertiesUtil.read(config);
    }

    private String getAddress(String user) {
        String address = this.addresses.get(user);
        while (address != null && !address.contains("@")) {
            address = this.addresses.get(address);
        }
        return address;
    }

    private String getAdminAddress() {
        return this.getAddress("admin");
    }

    public void send(Throwable t) {
        try {
            String from = this.getFrom();
            String to = this.getAdminAddress();
            String subject = "Internal Error";
            String text = this.createContent(t);
            this.send(from, to, null, subject, text);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "error sending mail", e);
        }
    }

    private String createContent(Throwable t) throws IOException {
        StringBuilder result = new StringBuilder();
        try (StringWriter out = new StringWriter();){
            t.printStackTrace(new PrintWriter(out));
            result.append(out.toString());
        }
        return result.toString();
    }

    public <P> void sendProblems(String user, String name, Map<P, Change[]> problems, EnvironmentRetriever<P> toEnv) {
        String from = this.getFrom();
        String to = this.getAddress(user);
        String cc = this.getAdminAddress();
        String subject = name + " found";
        String text = this.createContentForProblems(name.toLowerCase(), problems, toEnv);
        if (to == null) {
            text = user + " could not be reached, you have been sent this email instead!\n" + text;
            to = this.getAdminAddress();
        }
        this.send(from, to, cc, subject, text);
    }

    private String getFrom() {
        return "cerberus.ci." + this.name.replace(" ", "_").toLowerCase() + "@" + this.getAddress("admin").substring(this.getAddress("admin").indexOf("@") + 1);
    }

    private <P> String createIntroForProblems(String name, Set<P> problems, EnvironmentRetriever<P> toEnv) {
        StringBuilder content = new StringBuilder();
        content.append("The CI has found ");
        boolean first = true;
        for (BuildEnvironment env : (BuildEnvironment[])problems.stream().map(p -> toEnv.retrieve(p)).distinct().toArray(BuildEnvironment[]::new)) {
            if (first) {
                first = false;
            } else {
                content.append(", ");
            }
            long count = problems.stream().filter(p -> toEnv.retrieve(p).equals(env)).count();
            content.append(count + " " + name + (count != 1L ? "s" : "") + " on " + env.toString());
        }
        content.append(" you might be responsible for! See details below.");
        return content.toString();
    }

    private <P> String createContentForProblems(String name, Map<P, Change[]> problems, EnvironmentRetriever<P> toEnv) {
        StringBuilder string = new StringBuilder();
        string.append(this.createIntroForProblems(name, problems.keySet(), toEnv));
        int id = 0;
        for (P problem : problems.keySet()) {
            string.append("\n\n");
            for (int i = 0; i < 100; ++i) {
                string.append("#");
            }
            string.append("\n");
            string.append(this.createContentForProblem(name, id++, problem, problems.get(problem)));
        }
        return string.toString();
    }

    private <P> String createContentForProblem(String name, int id, P problem, Change[] changes) {
        StringBuilder string = new StringBuilder();
        string.append(id + ") " + problem + "\n");
        string.append("\n");
        string.append("You have been identified as a suspect ");
        if (changes.length > 0) {
            string.append("due to the following changes (" + changes.length + ") you made:\n");
        } else {
            string.append("because no specific changes at all could be assiociated with the " + name + "!");
        }
        string.append("\n");
        for (Change change : changes) {
            string.append(change.toString() + "\n");
            if (change.diff != null) {
                string.append(change.diff + "\n");
            }
            string.append("\n");
        }
        return string.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String from, String to, String cc, String subject, String text) {
        try {
            Properties props = System.getProperties();
            props.put("mail.smtp.host", this.host);
            Session session = Session.getInstance((Properties)System.getProperties(), null);
            MimeMessage msg = new MimeMessage(session);
            msg.setHeader("X-Mailer", "smptsend");
            msg.setSentDate(new Date());
            msg.setSubject(subject);
            msg.setFrom((Address)new InternetAddress(from));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            if (cc != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)cc, (boolean)false));
            }
            msg.setText(text);
            try (SMTPTransport transport = null;){
                transport = (SMTPTransport)session.getTransport();
                transport.connect();
                transport.sendMessage((Message)msg, msg.getAllRecipients());
            }
        }
        catch (MessagingException e) {
            this.logger.log(Level.SEVERE, "error sending mail", e);
        }
    }

    @FunctionalInterface
    public static interface EnvironmentRetriever<P> {
        public BuildEnvironment retrieve(P var1);
    }
}

