/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.io;

import at.jku.ssw.mevss.cerberus.ci.master.io.WatchableFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class WatchingFileInputStream
extends InputStream {
    private final Object lock = new Object();
    private final File file;
    private final long writerCursor;
    private final InputStream in;
    private long cursor;
    private final List<byte[]> bufs = new LinkedList<byte[]>();

    public WatchingFileInputStream(File file, Function<File, InputStream> factory) {
        this.file = file;
        this.writerCursor = WatchableFileOutputStream.watch(file, this);
        this.in = this.writerCursor != 0L ? factory.apply(file) : null;
        this.cursor = 0L;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read > 0) {
            return buf[0];
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int read;
        if (this.writerCursor < 0L) {
            assert (this.in != null);
            read = this.in.read(buf, off, len);
        } else if (this.cursor < this.writerCursor) {
            assert (this.in != null);
            read = this.in.read(buf, off, Math.min(len, (int)(this.writerCursor - this.cursor)));
        } else {
            Object object = this.lock;
            synchronized (object) {
                while (this.bufs.isEmpty()) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
                byte[] mybuf = this.bufs.remove(0);
                if (mybuf != null && mybuf.length >= 0) {
                    if (mybuf.length > len) {
                        System.arraycopy(mybuf, 0, buf, off, len);
                        read = len;
                        byte[] mynewbuf = new byte[mybuf.length - len];
                        System.arraycopy(mybuf, 0, mynewbuf, 0, mynewbuf.length);
                        this.bufs.add(0, mynewbuf);
                    } else {
                        System.arraycopy(mybuf, 0, buf, off, mybuf.length);
                        read = mybuf.length;
                    }
                } else {
                    this.bufs.add(null);
                    read = -1;
                }
            }
        }
        this.cursor += (long)Math.max(0, read);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.cursor = -1L;
            this.bufs.clear();
            this.bufs.add(null);
            this.lock.notifyAll();
            if (this.in != null) {
                this.in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(byte[] buf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cursor < 0L) {
                return false;
            }
            if (buf != null) {
                byte[] mybuf = new byte[len];
                System.arraycopy(buf, off, mybuf, 0, len);
                this.bufs.add(mybuf);
            } else {
                this.bufs.add(null);
            }
            this.lock.notifyAll();
            return true;
        }
    }
}

