/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.io;

import at.jku.ssw.mevss.cerberus.ci.master.io.WatchingFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public class WatchableFileOutputStream
extends OutputStream {
    private static final Object LOCK = new Object();
    private static final Map<File, WatchableFileOutputStream> INSTANCES = new WeakHashMap<File, WatchableFileOutputStream>();
    private static final List<WatchingFileInputStream> WAITING = new CopyOnWriteArrayList<WatchingFileInputStream>();
    private final Object lock = new Object();
    private final File file;
    private final OutputStream out;
    private long cursor;
    private final List<WatchingFileInputStream> readers = Collections.synchronizedList(new CopyOnWriteArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long watch(File file, WatchingFileInputStream in) {
        Object object = LOCK;
        synchronized (object) {
            WatchableFileOutputStream instance = INSTANCES.get(file);
            if (instance == null) {
                if (file.exists()) {
                    return -1L;
                }
                WAITING.add(in);
                return 0L;
            }
            return instance.watch(in);
        }
    }

    public WatchableFileOutputStream(File file, Function<File, OutputStream> factory) {
        this(file, factory.apply(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WatchableFileOutputStream(File file, OutputStream out) {
        this.file = file;
        this.out = out;
        this.cursor = 0L;
        Object object = LOCK;
        synchronized (object) {
            INSTANCES.put(file, this);
            for (WatchingFileInputStream waiting : WAITING) {
                if (!waiting.getFile().equals(file)) continue;
                WAITING.remove(waiting);
                this.watch(waiting);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long watch(WatchingFileInputStream reader) {
        Object object = this.lock;
        synchronized (object) {
            this.readers.add(reader);
            return this.cursor;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(buf, off, len);
            this.cursor += (long)len;
            for (WatchingFileInputStream reader : this.readers) {
                boolean active = reader.put(buf, off, len);
                if (active) continue;
                this.readers.remove(reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            Iterator<WatchingFileInputStream> iterator = LOCK;
            synchronized (iterator) {
                INSTANCES.remove(this.file);
            }
            this.out.close();
            for (WatchingFileInputStream reader : this.readers) {
                reader.put(null, 0, 0);
            }
            this.cursor = -1L;
        }
    }
}

