/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.filetransfer;

import at.jku.ssw.mevss.cerberus.ci.master.filetransfer.FileTransferServerProtocol;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTransferServer
implements AutoCloseable {
    private final int port;
    private final Logger logger;
    private final ServerSocket server;
    private final Object lock;
    private final Map<Integer, Transfer> transfers;
    private final Random random;
    private final Thread worker;

    public FileTransferServer(int port) throws IOException {
        this.port = port;
        this.logger = Logger.getLogger("cerberus.filetransfer.server." + port);
        this.logger.info("opening socket");
        this.server = new ServerSocket(port);
        this.lock = new Object();
        this.transfers = new HashMap<Integer, Transfer>();
        this.random = new Random();
        this.worker = new Thread(this::run, FileTransferServer.class.getSimpleName() + " Server Thread");
        this.logger.info("starting");
        this.worker.start();
    }

    public int getPort() {
        return this.port;
    }

    public int register(Type type, String prefix, File root, String[] extensions) {
        return this.register(type, prefix, root, null, extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register(Type type, String prefix, File root, String hiddenFilePrefix, String[] extensions) {
        Object object = this.lock;
        synchronized (object) {
            int ticket;
            while ((ticket = this.random.nextInt()) == 0 || ticket < 0 || this.transfers.containsKey(ticket)) {
            }
            Transfer transfer = new Transfer(ticket, type, prefix, root, hiddenFilePrefix, extensions);
            this.transfers.put(ticket, transfer);
            this.logger.info("registered new transfer " + transfer + " with ticket " + ticket);
            return ticket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(int ticket) throws InterruptedException {
        Transfer transfer;
        this.logger.info("unregistering transfer with ticket " + ticket);
        Object object = this.lock;
        synchronized (object) {
            transfer = this.transfers.remove(ticket);
        }
        object = transfer;
        synchronized (object) {
            while (transfer.running > 0) {
                this.logger.info("transfer with ticket still running, waiting ...");
                transfer.wait();
            }
        }
        this.logger.info("unregistered transfer with ticket " + ticket + " (" + transfer + ")");
    }

    @Override
    public void close() {
        try {
            this.logger.info("closing");
            this.worker.interrupt();
            this.server.close();
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "internal error", t);
        }
        finally {
            this.logger.info("closed");
        }
    }

    private void run() {
        this.logger.info("running");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Socket socket = this.server.accept();
                this.logger.info("accepted client, spawning worker");
                Thread worker = new Thread(() -> this.run(socket), FileTransferServer.class.getSimpleName() + " Worker Thread");
                worker.start();
            }
            catch (SocketException se) {
                if (se.getMessage().equalsIgnoreCase("Socket closed")) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                this.logger.log(Level.SEVERE, "internal error", se);
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "internal error", t);
                Thread.currentThread().interrupt();
            }
        }
        this.logger.info("terminated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(Socket socket) {
        Logger logger = this.logger;
        Transfer transfer = null;
        try {
            ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream in = new ObjectInputStream(socket.getInputStream());
            int ticket = in.readInt();
            Object object = this.lock;
            synchronized (object) {
                transfer = this.transfers.get(ticket);
                logger = Logger.getLogger(logger.getName() + ".worker." + ticket);
                Transfer transfer2 = transfer;
                synchronized (transfer2) {
                    if (transfer.running > 0 && transfer.type == Type.SINGLE_DOWNLOAD) {
                        logger.warning("aborting because this ticket does not support multiple download and another is already running");
                        return;
                    }
                    ++transfer.running;
                    transfer.notifyAll();
                }
            }
            logger.info("running");
            FileTransferServerProtocol protocol = new FileTransferServerProtocol(String.valueOf(ticket));
            switch (transfer.type) {
                case MULTI_DOWNLOAD: 
                case SINGLE_DOWNLOAD: {
                    protocol.send(transfer.prefix, transfer.root, transfer.hiddenFilePrefix, transfer.extensions, out);
                    break;
                }
                case UPLOAD: {
                    protocol.read(transfer.prefix, transfer.root, in);
                    break;
                }
            }
            out.close();
            in.close();
            return;
        }
        catch (SocketException se) {
            if (se.getMessage().equalsIgnoreCase("Broken pipe")) {
                logger.info("other end disconnected, did not obey protocol");
                return;
            }
            logger.warning("communcation error: " + se);
            return;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "unexpected error (" + (transfer != null ? transfer.getName() : null) + ")", t);
            return;
        }
        finally {
            block52: {
                if (transfer != null) {
                    Transfer se = transfer;
                    synchronized (se) {
                        --transfer.running;
                        transfer.notifyAll();
                        if (transfer.type == Type.SINGLE_DOWNLOAD) {
                            try {
                                this.unregister(transfer.ticket);
                            }
                            catch (InterruptedException e) {
                                if ($assertionsDisabled) break block52;
                                throw new AssertionError((Object)"here be dragons");
                            }
                        }
                    }
                }
            }
            try {
                socket.close();
            }
            catch (IOException se) {}
            logger.info("terminated");
        }
    }

    public static enum Type {
        MULTI_DOWNLOAD,
        SINGLE_DOWNLOAD,
        UPLOAD;

    }

    private static class Transfer {
        int ticket;
        Type type;
        String prefix;
        File root;
        String hiddenFilePrefix;
        String[] extensions;
        int running;

        public Transfer(int ticket, Type type, String prefix, File root, String hiddenFilePrefix, String[] extensions) {
            this.ticket = ticket;
            this.type = type;
            this.prefix = prefix;
            this.root = root;
            this.hiddenFilePrefix = hiddenFilePrefix;
            this.extensions = extensions;
            this.running = 0;
        }

        public String getName() {
            return this.toString();
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.prefix + " " + this.root;
        }
    }
}

