/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.config;

import at.jku.ssw.mevss.cerberus.ci.master.config.Token;
import at.jku.ssw.mevss.cerberus.ci.master.config.TokenType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class Scanner
implements AutoCloseable {
    private final File source;
    private final Reader in;
    private char ch;
    private int row;
    private int col;

    public Scanner(File file) throws FileNotFoundException, IOException {
        this(file, new FileReader(file));
    }

    public Scanner(File source, Reader in) throws IOException {
        this.source = source;
        this.in = in;
        this.nextChar();
    }

    public File getSource() {
        return this.source;
    }

    private char nextChar() throws IOException {
        char result = this.ch;
        int ch = this.in.read();
        this.ch = ch < 0 ? (char)'\u0000' : (char)ch;
        if (ch == 10) {
            ++this.row;
            this.col = 0;
        } else {
            ++this.col;
        }
        return result;
    }

    public Token next() throws IOException {
        this.skipWhitespaces();
        int row = this.row;
        int col = this.col;
        switch (this.ch) {
            case '\u0000': {
                return new Token(TokenType.EOF, null, row, col);
            }
            case '%': {
                this.skipComment();
                return this.next();
            }
            case '{': {
                this.nextChar();
                return new Token(TokenType.L_BRACE, "{", row, col);
            }
            case '}': {
                this.nextChar();
                return new Token(TokenType.R_BRACE, "}", row, col);
            }
            case ',': {
                this.nextChar();
                return new Token(TokenType.COMMA, ",", row, col);
            }
            case ':': {
                this.nextChar();
                return new Token(TokenType.COLON, ":", row, col);
            }
            case '\"': {
                this.nextChar();
                return new Token(TokenType.STRING, this.readString(), row, col);
            }
        }
        if (Character.isDigit(this.ch)) {
            long value = this.readNumber();
            return new Token(TokenType.NUMBER, String.valueOf(value), row, col);
        }
        if (Character.isLetter(this.ch)) {
            String ident = this.readIdentifier();
            for (TokenType type : TokenType.values()) {
                if (type.value == null || !type.value.equals(ident)) continue;
                return new Token(type, ident, row, col);
            }
            return new Token(TokenType.UNKNOWN, ident, row, col);
        }
        this.nextChar();
        return new Token(TokenType.UNKNOWN, String.valueOf(this.ch), row, col);
    }

    private long readNumber() throws IOException {
        long value = 0L;
        while (Character.isDigit(this.ch)) {
            int digit = this.ch - 48;
            value = value * 10L + (long)digit;
            this.nextChar();
        }
        return value;
    }

    private String readIdentifier() throws IOException {
        StringBuilder string = new StringBuilder();
        while (Character.isLetter(this.ch) || this.ch == '-') {
            string.append(this.ch);
            this.nextChar();
        }
        return string.toString();
    }

    private String readString() throws IOException {
        StringBuilder string = new StringBuilder();
        char c = this.nextChar();
        while (c != '\"' && c != '\u0000') {
            string.append(c);
            c = this.nextChar();
        }
        return string.toString();
    }

    private void skipWhitespaces() throws IOException {
        while (Character.isWhitespace(this.ch) && this.ch != '\u0000') {
            this.nextChar();
        }
    }

    private void skipComment() throws IOException {
        while (this.ch != '\u0000' && this.ch != '\n') {
            this.nextChar();
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

