/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.config;

import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigDeployment;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigDirectory;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigPerformance;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigPlatform;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigProject;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigSchedule;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigTest;
import at.jku.ssw.mevss.cerberus.ci.master.config.Scanner;
import at.jku.ssw.mevss.cerberus.ci.master.config.Token;
import at.jku.ssw.mevss.cerberus.ci.master.config.TokenType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class Parser
implements AutoCloseable {
    private final Scanner scanner;
    private Token la;
    private Token t;

    public Parser(Scanner scanner) throws IOException {
        this.scanner = scanner;
        this.t = null;
        this.la = null;
        this.scan();
    }

    private void check(TokenType t) throws IOException {
        if (this.la.type != t) {
            throw new IOException("Unexpected token: " + this.la + " (expected " + (Object)((Object)t) + ") @ " + this.la.row + ":" + this.la.col);
        }
        this.scan();
    }

    private void scan() throws IOException {
        this.t = this.la;
        this.la = this.scanner.next();
    }

    public ConfigProject parse() throws IOException {
        ConfigProject project = new ConfigProject();
        project.file = this.scanner.getSource();
        project.revision = project.file.lastModified();
        this.check(TokenType.PROJECT);
        this.check(TokenType.STRING);
        project.name = this.t.value;
        if (this.la.type == TokenType.CAPACITY) {
            this.scan();
            this.check(TokenType.NUMBER);
            project.capacity = Integer.parseInt(this.t.value);
        } else {
            project.capacity = -1;
        }
        if (this.la.type == TokenType.HISTORY) {
            this.scan();
            this.check(TokenType.NUMBER);
            project.history = Integer.parseInt(this.t.value);
        } else {
            project.history = -1;
        }
        if (this.la.type == TokenType.PUBLISH) {
            this.scan();
            project.publish = true;
        } else {
            project.publish = false;
        }
        this.check(TokenType.L_BRACE);
        project.src = this.parseSrc();
        this.check(TokenType.WORKING_DIRECTORY);
        this.check(TokenType.STRING);
        project.working = this.t.value;
        project.platforms = this.parsePlatforms();
        project.tests = this.parseTests();
        project.performances = this.parsePerformances();
        project.deploy = this.parseDeployment();
        project.schedules = this.parseSchedules();
        project.reactiveTests = this.parseReactiveTests();
        project.reactivePerformances = this.parseReactivePerformances();
        this.check(TokenType.R_BRACE);
        this.check(TokenType.EOF);
        return project;
    }

    private String[] parseReactivePerformances() throws IOException {
        this.check(TokenType.REACTIVE_PERFORMANCES);
        return this.parseStringList();
    }

    private ConfigDirectory[] parseSrc() throws IOException {
        this.check(TokenType.SRC);
        return this.parseSrcDirectories();
    }

    private ConfigDirectory[] parseSrcDirectories() throws IOException {
        ArrayList<ConfigDirectory> dirs = new ArrayList<ConfigDirectory>();
        this.check(TokenType.L_BRACE);
        while (this.la.type == TokenType.DIRECTORY) {
            dirs.add(this.parseSrcDirectory());
        }
        this.check(TokenType.R_BRACE);
        return dirs.toArray(new ConfigDirectory[dirs.size()]);
    }

    private ConfigDirectory parseSrcDirectory() throws IOException {
        ConfigDirectory result = new ConfigDirectory();
        this.check(TokenType.DIRECTORY);
        if (this.la.type == TokenType.STRING) {
            this.check(TokenType.STRING);
            result.name = this.t.value;
        }
        if (this.la.type == TokenType.REPOSITORY) {
            this.check(TokenType.REPOSITORY);
            switch (this.la.type) {
                case SVN: 
                case HG: 
                case CERBERUS: 
                case DIRECTORY: {
                    this.scan();
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            result.type = this.t.value;
            this.check(TokenType.STRING);
            result.url = this.t.value;
            if (result.type.equals("directory")) {
                result.url = this.scanner.getSource().getParent() + File.separator + result.url;
            }
            if (this.la.type == TokenType.BRANCH) {
                this.scan();
                this.check(TokenType.STRING);
                result.branch = this.t.value;
            }
            if (this.la.type == TokenType.MAP) {
                this.scan();
                this.check(TokenType.STRING);
                result.map = this.t.value;
                if (!result.map.endsWith("/")) {
                    result.map = result.map + "/";
                }
            }
        } else {
            result.type = "none";
        }
        if (this.la.type == TokenType.L_BRACE) {
            result.children = this.parseSrcDirectories();
        }
        if (result.name == null) {
            result.name = result.url.substring(result.url.lastIndexOf(47) + 1);
        }
        return result;
    }

    private ConfigPlatform[] parsePlatforms() throws IOException {
        ArrayList<ConfigPlatform> result = new ArrayList<ConfigPlatform>();
        this.check(TokenType.PLATFORMS);
        this.check(TokenType.L_BRACE);
        while (this.la.type == TokenType.PLATFORM) {
            ConfigPlatform platform = new ConfigPlatform();
            this.check(TokenType.PLATFORM);
            this.check(TokenType.STRING);
            platform.os = this.t.value;
            this.check(TokenType.STRING);
            platform.architecture = this.t.value;
            this.check(TokenType.NUMBER);
            platform.addressLength = Integer.parseInt(this.t.value);
            this.check(TokenType.STRING);
            platform.buildCommand = this.t.value.split(" ");
            result.add(platform);
        }
        this.check(TokenType.R_BRACE);
        return result.toArray(new ConfigPlatform[result.size()]);
    }

    private ConfigTest[] parseTests() throws IOException {
        ArrayList<ConfigTest> result = new ArrayList<ConfigTest>();
        this.check(TokenType.TESTS);
        this.check(TokenType.L_BRACE);
        while (this.la.type == TokenType.TEST) {
            result.add(this.parseTest());
        }
        this.check(TokenType.R_BRACE);
        return result.toArray(new ConfigTest[result.size()]);
    }

    private ConfigPerformance[] parsePerformances() throws IOException {
        ArrayList<ConfigPerformance> result = new ArrayList<ConfigPerformance>();
        this.check(TokenType.PERFORMANCES);
        this.check(TokenType.L_BRACE);
        while (this.la.type == TokenType.PERFORMANCE) {
            result.add(this.parsePerformance());
        }
        this.check(TokenType.R_BRACE);
        return result.toArray(new ConfigPerformance[result.size()]);
    }

    private ConfigDeployment parseDeployment() throws IOException {
        if (this.la.type == TokenType.DEPLOY) {
            this.scan();
            ConfigDeployment result = new ConfigDeployment();
            this.check(TokenType.STRING);
            result.location = new File(this.t.value);
            this.check(TokenType.STRING);
            result.command = this.t.value.split(" ");
            return result;
        }
        return null;
    }

    private ConfigPerformance parsePerformance() throws IOException {
        ConfigPerformance result = new ConfigPerformance();
        this.check(TokenType.PERFORMANCE);
        this.check(TokenType.STRING);
        result.name = this.t.value;
        this.check(TokenType.STRING);
        result.command = this.t.value.split(" ");
        return result;
    }

    private ConfigTest parseTest() throws IOException {
        ConfigTest result = new ConfigTest();
        this.check(TokenType.TEST);
        this.check(TokenType.STRING);
        result.name = this.t.value;
        this.check(TokenType.STRING);
        result.command = this.t.value.split(" ");
        return result;
    }

    private ConfigSchedule[] parseSchedules() throws IOException {
        ArrayList<ConfigSchedule> result = new ArrayList<ConfigSchedule>();
        this.check(TokenType.SCHEDULES);
        this.check(TokenType.L_BRACE);
        block5: while (true) {
            ConfigSchedule schedule = new ConfigSchedule();
            switch (this.la.type) {
                case DAILY: {
                    this.check(TokenType.DAILY);
                    schedule.type = "daily";
                    this.check(TokenType.STRING);
                    schedule.name = this.t.value;
                    this.check(TokenType.NUMBER);
                    schedule.hours = Integer.parseInt(this.t.value);
                    this.check(TokenType.COLON);
                    this.check(TokenType.NUMBER);
                    schedule.minutes = Integer.parseInt(this.t.value);
                    schedule.tests = this.parseStringList();
                    schedule.performances = this.parseStringList();
                    if (this.la.type != TokenType.DEPLOY) break;
                    this.check(TokenType.DEPLOY);
                    schedule.deploy = true;
                    break;
                }
                case WEEKLY: {
                    this.check(TokenType.WEEKLY);
                    schedule.type = "weekly";
                    this.check(TokenType.STRING);
                    schedule.name = this.t.value;
                    this.check(TokenType.NUMBER);
                    schedule.day_of_week = Integer.parseInt(this.t.value);
                    this.check(TokenType.NUMBER);
                    schedule.hours = Integer.parseInt(this.t.value);
                    this.check(TokenType.COLON);
                    this.check(TokenType.NUMBER);
                    schedule.minutes = Integer.parseInt(this.t.value);
                    schedule.tests = this.parseStringList();
                    schedule.performances = this.parseStringList();
                    if (this.la.type != TokenType.DEPLOY) break;
                    this.check(TokenType.DEPLOY);
                    schedule.deploy = true;
                    break;
                }
                case MONTHLY: {
                    this.check(TokenType.MONTHLY);
                    schedule.type = "monthly";
                    this.check(TokenType.STRING);
                    schedule.name = this.t.value;
                    this.check(TokenType.NUMBER);
                    schedule.day_of_month = Integer.parseInt(this.t.value);
                    this.check(TokenType.NUMBER);
                    schedule.day_of_week = Integer.parseInt(this.t.value);
                    this.check(TokenType.NUMBER);
                    schedule.hours = Integer.parseInt(this.t.value);
                    this.check(TokenType.COLON);
                    this.check(TokenType.NUMBER);
                    schedule.minutes = Integer.parseInt(this.t.value);
                    schedule.tests = this.parseStringList();
                    schedule.performances = this.parseStringList();
                    if (this.la.type != TokenType.DEPLOY) break;
                    this.check(TokenType.DEPLOY);
                    schedule.deploy = true;
                    break;
                }
                default: {
                    break block5;
                }
            }
            result.add(schedule);
        }
        this.check(TokenType.R_BRACE);
        return result.toArray(new ConfigSchedule[result.size()]);
    }

    private String[] parseReactiveTests() throws IOException {
        this.check(TokenType.REACTIVE_TESTS);
        return this.parseStringList();
    }

    private String[] parseStringList() throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        this.check(TokenType.L_BRACE);
        if (this.la.type == TokenType.STRING) {
            this.check(TokenType.STRING);
            strings.add(this.t.value);
            while (this.la.type == TokenType.COMMA) {
                this.check(TokenType.COMMA);
                this.check(TokenType.STRING);
                strings.add(this.t.value);
            }
        }
        this.check(TokenType.R_BRACE);
        return strings.toArray(new String[strings.size()]);
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }
}

