/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.blaming;

import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.Blamer;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.BuildError;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.LearningBlamer;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.TestFailure;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.RepositoryException;
import at.jku.ssw.mevss.cerberus.ci.master.storage.Storage;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class LearningBlamerTest {
    private static final String TEST_NAME = "my_test";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        File dir = FileUtil.createTemporaryDirectory();
        try {
            TestRepository repository = new TestRepository();
            Storage storage = new Storage(dir, new BuildEnvironment[]{new BuildEnvironment("Linux", "x86_64", 64)}, -1, -1);
            LearningBlamerTest.writeTestBuild(storage, repository, true, LearningBlamerTest.createChange(repository, "A", 1));
            LearningBlamerTest.writeTestBuild(storage, repository, false, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, true, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, false, LearningBlamerTest.createChange(repository, "A", 1), LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "A", 1));
            LearningBlamerTest.writeTestBuild(storage, repository, true, LearningBlamerTest.createChange(repository, "A", 1));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "A", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "A", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, null, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamerTest.writeTestBuild(storage, repository, false, LearningBlamerTest.createChange(repository, "B", 2));
            LearningBlamer blamer = new LearningBlamer("test", storage, Collections.singletonMap(repository.getName(), repository));
            int i = 0;
            while ((long)i < repository.getRevisionNumber(null)) {
                blamer.blame(i, null, new MyLogger<BuildError>(), new MyLogger<TestFailure>());
                ++i;
            }
        }
        finally {
            FileUtil.deleteTree(dir);
        }
    }

    private static Change createChange(TestRepository repo, String file, int ... lines) {
        return new Change(repo.getName(), repo.getRevisionNumber(null), "some dude", file, "some message", lines, "some diff");
    }

    private static void writeTestBuild(Storage storage, TestRepository repo, Boolean success, Change ... changes) throws IOException {
        int id = (int)repo.getRevisionNumber(null);
        storage.writeNewBuildMeta(id, Collections.singletonMap(repo.getName(), repo.getRevisionNumber(null)), "test", storage.getEnvironments(), new String[]{TEST_NAME}, new String[0]);
        repo.changes.add(changes);
        for (BuildEnvironment env : storage.getEnvironments()) {
            storage.writeBuildEntry(id, env, true);
            if (success == null) continue;
            storage.writeTestEntry(id, env, TEST_NAME, success);
        }
    }

    private static class MyLogger<T>
    implements Blamer.JudgementConsumer<T> {
        private MyLogger() {
        }

        @Override
        public void judge(String author, Map<T, Change[]> problems) {
            System.out.println("blaming " + author + ":");
            System.out.println();
            for (T problem : problems.keySet()) {
                System.out.println(problem);
                for (Change change : problems.get(problem)) {
                    System.out.println(change);
                }
                System.out.println();
            }
        }
    }

    private static class TestRepository
    extends Repository {
        private final List<Change[]> changes = new ArrayList<Change[]>();

        public TestRepository() {
            super("test", new File("abc"));
        }

        @Override
        public String getHiddenFilePrefix() {
            return null;
        }

        @Override
        public long getRevisionNumber(Logger logger) throws RepositoryException {
            return this.changes.size();
        }

        @Override
        public boolean update(Logger logger) throws RepositoryException {
            return false;
        }

        @Override
        public Change[] getChanges(long revision, Logger logger) throws RepositoryException {
            return this.changes.get((int)revision);
        }
    }
}

