/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.blaming;

import at.jku.ssw.mevss.cerberus.ci.master.blaming.Blamer;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.BuildError;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.TestFailure;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.storage.Storage;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class LearningBlamer
extends Blamer {
    private static final double THRESHOLD = 0.1;

    public LearningBlamer(String name, Storage storage, Map<String, Repository> repositories) {
        super(name, storage, repositories);
    }

    @Override
    protected boolean isBuildErrorReason(BuildError error, Change change) {
        if (error.file != null) {
            return super.isBuildErrorReason(error, change);
        }
        Map<Long, Change[]> changes = this.collectSimilarProblems(error, this::retrieveBuildErrors);
        Map<String, Double> scores = this.computeLocationScores(changes.values());
        if (scores.values().stream().anyMatch(s -> s >= 0.1)) {
            Double score = scores.get(change.file);
            return score != null && score >= 0.1;
        }
        return super.isBuildErrorReason(error, change);
    }

    @Override
    protected boolean isTestFailureReason(TestFailure failure, Change change) {
        Map<Long, Change[]> changes = this.collectSimilarProblems(failure, this::retrieveTestFailures);
        Map<String, Double> scores = this.computeLocationScores(changes.values());
        if (scores.values().stream().anyMatch(s -> s >= 0.1)) {
            Double score = scores.get(change.file);
            return score != null && score >= 0.1;
        }
        return super.isTestFailureReason(failure, change);
    }

    private <P> Map<Long, Change[]> collectSimilarProblems(P problem, Blamer.ProblemRetriever<P> retriever) {
        HashMap<Long, Change[]> results = new HashMap<Long, Change[]>();
        long[] builds = this.getStorage().getBuilds();
        int index_last_without = -1;
        for (int index = 0; index < builds.length; ++index) {
            long build = builds[index];
            try {
                if (ArraysUtil.contains(retriever.retrieve(build), problem)) {
                    long build_failed = build;
                    if (index_last_without <= 0) continue;
                    long build_ok = builds[index_last_without];
                    Change[] changes = this.getChanges(build_ok, build_failed);
                    results.put(build_failed, changes);
                    index_last_without = -1;
                    continue;
                }
                index_last_without = index;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return results;
    }

    private <P> Map<String, Double> computeLocationScores(Collection<Change[]> reasons) {
        HashMap<String, MutableDouble> scores = new HashMap<String, MutableDouble>();
        for (Change[] changes : reasons) {
            double score_for_line = 1.0 / (double)Arrays.stream(changes).map(c -> c.lines).flatMapToInt(l -> Arrays.stream(l)).count();
            for (Change change : changes) {
                String file = change.file;
                MutableDouble score = (MutableDouble)scores.get(file);
                if (score == null) {
                    score = new MutableDouble();
                    scores.put(file, score);
                }
                score.value += score_for_line * (double)change.lines.length;
            }
        }
        double total = scores.values().stream().mapToDouble(s -> s.value).sum();
        return scores.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((MutableDouble)e.getValue()).value / total));
    }

    private static class MutableDouble {
        public double value;

        private MutableDouble() {
        }
    }
}

