/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master.blaming;

import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.BuildError;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.ErrorParser;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.TestFailure;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.clErrorParser;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.gccErrorParser;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.javacErrorParser;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.RepositoryException;
import at.jku.ssw.mevss.cerberus.ci.master.storage.Storage;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Blamer {
    private static final ErrorParser[] BUILD_ERROR_PARSERS = new ErrorParser[]{new javacErrorParser(), new gccErrorParser(), new clErrorParser()};
    protected final Logger logger;
    private final Storage storage;
    private final Map<String, Repository> repositories;

    public Blamer(String name, Storage storage, Map<String, Repository> repositories) {
        this.logger = Logger.getLogger("cerberus.blaming." + name);
        this.storage = storage;
        this.repositories = repositories;
    }

    protected Storage getStorage() {
        return this.storage;
    }

    public boolean blame(long id, String suspect, JudgementConsumer<BuildError> dredd_build, JudgementConsumer<TestFailure> dredd_test) {
        return this.blameBuildErrors(id, suspect, dredd_build) | this.blameTestFailures(id, suspect, dredd_test);
    }

    public boolean blameBuildErrors(long id, String suspect, JudgementConsumer<BuildError> dredd) {
        try {
            this.logger.info("blaming build errors of " + id);
            return this.blame(id, suspect, this::retrieveBuildErrors, this::hasBuildError, this::isBuildErrorReason, dredd);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "unexpected error", t);
            return false;
        }
    }

    public boolean blameTestFailures(long id, String suspect, JudgementConsumer<TestFailure> dredd) {
        try {
            this.logger.info("blaming test failures of " + id);
            return this.blame(id, suspect, this::retrieveTestFailures, this::hasTestFailure, this::isTestFailureReason, dredd);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "unexpected error", t);
            return false;
        }
    }

    public boolean blamePerformanceTestFailures(long id, String suspect, JudgementConsumer<TestFailure> dredd) {
        try {
            this.logger.info("blaming test failures of " + id);
            return this.blame(id, suspect, this::retrievePerformanceTestFailures, this::hasPerformanceTestFailure, this::isPerformanceTestFailureReason, dredd);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "unexpected error", t);
            return false;
        }
    }

    private <P> boolean blame(long id, String suspect, ProblemRetriever<P> retriever, ProblemChecker<P> checker, ProblemReasonChecker<P> reasoner, JudgementConsumer<P> dredd) throws IOException {
        this.logger.fine("collecting problems of " + id);
        HashMap<P, Change[]> problems = new HashMap<P, Change[]>();
        for (Object problem : retriever.retrieve(id)) {
            Change[] changes2;
            this.logger.finer("searching last build without " + problem);
            Long last = this.findLastBuildWithout(id, problem, checker);
            if (last != null) {
                this.logger.finest("searching changes");
                changes2 = this.getChanges(last, id);
                this.logger.finest("found " + changes2.length + " changes, reducing");
                Change[] reducedChanges = (Change[])Arrays.stream(changes2).filter(c -> reasoner.isReason(problem, (Change)c)).toArray(Change[]::new);
                if (reducedChanges.length > 0) {
                    this.logger.finest("reduced " + changes2.length + " changes to " + reducedChanges.length);
                    changes2 = reducedChanges;
                } else {
                    this.logger.finest("reduced all changes away, considering all changes");
                }
            } else {
                this.logger.finest("could not find build without this problem");
                changes2 = new Change[]{};
            }
            problems.put(problem, changes2);
        }
        if (problems.size() == 0) {
            this.logger.fine("no problems found");
            return false;
        }
        if (problems.values().stream().anyMatch(changes -> ((Change[])changes).length > 0)) {
            this.logger.fine("blaming authors for problems in " + id);
            int blamed = 0;
            for (String author : problems.values().stream().flatMap(cs -> Arrays.stream(cs)).map(c -> c.author).filter(a -> suspect == null || suspect.equals(a)).collect(Collectors.toSet())) {
                this.logger.finer("blaming " + author);
                HashMap myProblems = new HashMap();
                for (Object problem : problems.keySet()) {
                    boolean isMyProblem;
                    Change[] changes3 = (Change[])problems.get(problem);
                    if (changes3.length == 0) {
                        this.logger.finer("assigning " + problem + " because there are no changes associated with this problem at all");
                        isMyProblem = true;
                    } else {
                        boolean bl = isMyProblem = (changes3 = (Change[])Arrays.stream(changes3).filter(c -> c.author.equals(author)).toArray(Change[]::new)).length > 0;
                        if (isMyProblem) {
                            this.logger.finer("assigning " + problem + " because there are " + changes3.length + " changes matching");
                        } else {
                            this.logger.finer("not assigning " + problem + " because there are no changes matching");
                        }
                    }
                    if (!isMyProblem) continue;
                    myProblems.put(problem, changes3);
                }
                if (myProblems.size() <= 0) continue;
                this.logger.info("blaming " + author + " for " + myProblems.size() + " problems");
                dredd.judge(author, myProblems);
                ++blamed;
            }
            return blamed > 0;
        }
        this.logger.fine("blaming admin for problems in " + id + " without any changes");
        dredd.judge("admin", problems);
        return true;
    }

    protected BuildError[] retrieveBuildErrors(long id) throws IOException {
        HashSet<BuildError> errors = new HashSet<BuildError>();
        for (BuildEnvironment env : this.storage.getEnvironments(id)) {
            Boolean result = this.storage.getBuildResult(id, env);
            if (result != null && !result.booleanValue()) {
                File log = this.storage.getBuildLogFile(id, env);
                if (log.exists()) {
                    for (ErrorParser parser : BUILD_ERROR_PARSERS) {
                        for (BuildError error : parser.parse(env, log)) {
                            errors.add(error);
                        }
                    }
                } else {
                    this.logger.warning("build error detected, but cannot find log file");
                }
                if (!errors.isEmpty()) continue;
                errors.add(new BuildError(env, "Unknown build error"));
                continue;
            }
            if (result != null) continue;
            this.logger.warning("cannot retrieve build error for " + id + " on " + env + " - cannot determine build result (yet?)");
        }
        return errors.toArray(new BuildError[errors.size()]);
    }

    protected TestFailure[] retrieveTestFailures(long id) throws IOException {
        HashSet<TestFailure> failures = new HashSet<TestFailure>();
        for (BuildEnvironment env : this.storage.getEnvironments(id)) {
            Boolean build = this.storage.getBuildResult(id, env);
            if (build != null && build.booleanValue()) {
                for (String test : this.storage.getFunctionalTests(id)) {
                    Boolean result = this.storage.getFunctionalTestResult(id, env, test);
                    if (result != null && !result.booleanValue()) {
                        failures.add(new TestFailure(env, test));
                        continue;
                    }
                    if (result != null) continue;
                    this.logger.warning("cannot retrieve test failures for " + test + " in " + id + " on " + env + " - cannot determine test result (yet?)");
                }
                continue;
            }
            if (build != null) continue;
            this.logger.warning("cannot retrieve test failures for " + id + " on " + env + " - cannot determine build result (yet?)");
        }
        return failures.toArray(new TestFailure[failures.size()]);
    }

    protected TestFailure[] retrievePerformanceTestFailures(long id) throws IOException {
        HashSet<TestFailure> failures = new HashSet<TestFailure>();
        for (BuildEnvironment env : this.storage.getEnvironments(id)) {
            Boolean build = this.storage.getBuildResult(id, env);
            if (build != null && build.booleanValue()) {
                for (String test : this.storage.getPerformanceTests(id)) {
                    Boolean result = this.storage.getPerformanceTestResult(id, env, test);
                    if (result != null && !result.booleanValue()) {
                        failures.add(new TestFailure(env, test));
                        continue;
                    }
                    if (result != null) continue;
                    this.logger.warning("cannot retrieve performance test failures for " + test + " in " + id + " on " + env + " - cannot determine test result (yet?)");
                }
                continue;
            }
            if (build != null) continue;
            this.logger.warning("cannot retrieve performance test failures for " + id + " on " + env + " - cannot determine build result (yet?)");
        }
        return failures.toArray(new TestFailure[failures.size()]);
    }

    protected boolean hasBuildError(long id, BuildError error) throws IOException {
        Boolean result = this.storage.getBuildResult(id, error.env);
        return result != null && result == false;
    }

    protected boolean hasTestFailure(long id, TestFailure failure) throws IOException {
        Boolean build = this.storage.getBuildResult(id, failure.env);
        if (build != null) {
            Boolean result = this.storage.getFunctionalTestResult(id, failure.env, failure.test);
            return result != null && result == false;
        }
        return false;
    }

    protected boolean hasPerformanceTestFailure(long id, TestFailure failure) throws IOException {
        Boolean build = this.storage.getBuildResult(id, failure.env);
        if (build != null) {
            Boolean result = this.storage.getPerformanceTestResult(id, failure.env, failure.test);
            return result != null && result == false;
        }
        return false;
    }

    protected boolean isBuildErrorReason(BuildError error, Change change) {
        return !(error.file != null && !error.file.endsWith(change.file) && !change.file.endsWith(error.file) || error.line >= 0 && !ArraysUtil.contains(change.lines, error.line));
    }

    protected boolean isTestFailureReason(TestFailure failure, Change change) {
        return true;
    }

    protected boolean isPerformanceTestFailureReason(TestFailure failure, Change change) {
        return true;
    }

    protected <P> Long findLastBuildWithout(long id, P problem, ProblemChecker<P> checker) throws IOException {
        long[] builds = this.storage.getBuilds();
        int id_index = ArraysUtil.indexOf(builds, id);
        while (--id_index >= 0) {
            long candidate = builds[id_index];
            if (checker.has(candidate, problem)) continue;
            return candidate;
        }
        return null;
    }

    protected Change[] getChanges(long build1, long build2) throws IOException {
        Map<String, Long> revisions1 = this.storage.getRevisions(build1);
        Map<String, Long> revisions2 = this.storage.getRevisions(build2);
        return (Change[])((Stream)this.repositories.values().stream().parallel()).map(repo -> this.getChanges((Repository)repo, (Long)revisions1.get(repo.getName()), (Long)revisions2.get(repo.getName()))).flatMap(changes -> Arrays.stream(changes)).toArray(Change[]::new);
    }

    protected Change[] getChanges(Repository repo, Long revision1, Long revision2) {
        ArrayList<Change> result = new ArrayList<Change>();
        if (revision2 != null) {
            if ((revision1 = Long.valueOf(revision1 != null ? revision1 : 0L)) > revision2) {
                throw new RepositoryException("Illegal revision range [" + revision1 + ":" + revision2 + "]!");
            }
            for (long revision = revision1 + 1L; revision <= revision2; ++revision) {
                Change[] changes = repo.getChanges(revision, this.logger);
                if (changes == null) continue;
                result.addAll(Arrays.asList(changes));
            }
        }
        return (Change[])result.stream().toArray(Change[]::new);
    }

    @FunctionalInterface
    protected static interface ProblemReasonChecker<P> {
        public boolean isReason(P var1, Change var2);
    }

    @FunctionalInterface
    protected static interface ProblemChecker<P> {
        public boolean has(long var1, P var3) throws IOException;
    }

    @FunctionalInterface
    protected static interface ProblemRetriever<P> {
        public P[] retrieve(long var1) throws IOException;
    }

    @FunctionalInterface
    public static interface JudgementConsumer<P> {
        public void judge(String var1, Map<P, Change[]> var2);
    }
}

