/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteSlave;
import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SlaveStore {
    private final long CLEANUP_INTERVAL = 3600000L;
    private final Logger logger = Logger.getLogger("cerberus.slavestore");
    private final Object monitor = new Object();
    private final Map<BuildEnvironment, Map<String, RemoteSlave>> slaves = new HashMap<BuildEnvironment, Map<String, RemoteSlave>>();
    private final Map<String, Set<RemoteSlaveLock>> locks = new HashMap<String, Set<RemoteSlaveLock>>();
    private final Thread worker = new Thread(this::run, "SlaveStore Cleanup Worker");

    public SlaveStore() {
        this.worker.setDaemon(true);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteSlaveLock aquire(BuildEnvironment env, Capability capability, long timeout) throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            long waitUntil = System.currentTimeMillis() + timeout;
            while (System.currentTimeMillis() < waitUntil) {
                Object[] names = (String[])this.getSlaves(env).keySet().stream().toArray(String[]::new);
                Arrays.sort(names);
                for (Object candidate : names) {
                    if (capability.isReservationNeeded() && this.getLocks((String)candidate).size() != 0) continue;
                    try {
                        RemoteSlave slave = this.slaves.get(env).get(candidate);
                        slave.getID();
                        assert (slave != null);
                        if (!ArraysUtil.contains(slave.getCapabilities(), capability)) continue;
                        RemoteSlaveLock lock = new RemoteSlaveLock((String)candidate, slave, capability);
                        this.getLocks((String)candidate).add(lock);
                        this.monitor.notifyAll();
                        return lock;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.monitor.wait(waitUntil - System.currentTimeMillis());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RemoteSlave> getSlaves(BuildEnvironment env) {
        Object object = this.monitor;
        synchronized (object) {
            Map<String, RemoteSlave> result = this.slaves.get(env);
            if (result == null) {
                result = new HashMap<String, RemoteSlave>();
                this.slaves.put(env, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RemoteSlaveLock> getLocks(String slave) {
        Object object = this.monitor;
        synchronized (object) {
            Set<RemoteSlaveLock> result = this.locks.get(slave);
            if (result == null) {
                result = new HashSet<RemoteSlaveLock>();
                this.locks.put(slave, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String id, String os, String arch, int length, RemoteSlave slave) throws RemoteException {
        BuildEnvironment env = new BuildEnvironment(os, arch, length);
        this.logger.info("registering slave for " + env + " (" + id + ")");
        Object object = this.monitor;
        synchronized (object) {
            this.getLocks(id).clear();
            this.getSlaves(env).put(id, slave);
            this.logger.info("slave " + id + " added");
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String id) throws RemoteException {
        this.logger.info("unregistering slave " + id);
        Object object = this.monitor;
        synchronized (object) {
            boolean removed = this.slaves.values().stream().map(m -> m.remove(id) != null).reduce(false, (b1, b2) -> b1 != false || b2 != false);
            if (removed) {
                this.logger.info("slave " + id + " removed");
            } else {
                this.logger.warning("slave " + id + " not found, ignoring");
            }
            this.monitor.notifyAll();
        }
    }

    private void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                RemoteSlave[] slaves;
                Thread.sleep(3600000L);
                for (RemoteSlave slave : slaves = this.getAllSlaves()) {
                    try {
                        slave.getID();
                    }
                    catch (RemoteException re) {
                        this.logger.warning("noticed a slave as unreachable, trying to identify and remove him");
                        this.removeUnreachable(slave);
                    }
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "internal error", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteSlave[] getAllSlaves() {
        Object object = this.monitor;
        synchronized (object) {
            ArrayList<RemoteSlave> result = new ArrayList<RemoteSlave>();
            for (Map<String, RemoteSlave> slaves : this.slaves.values()) {
                result.addAll(slaves.values());
            }
            return result.toArray(new RemoteSlave[result.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnreachable(RemoteSlave slave) {
        Object object = this.monitor;
        synchronized (object) {
            block3: for (Map<String, RemoteSlave> slaves : this.slaves.values()) {
                for (String id : slaves.keySet()) {
                    RemoteSlave candidate = slaves.get(id);
                    if (slave != candidate) continue;
                    this.logger.warning("identified unreachable slave as " + id + ", removing");
                    slaves.remove(id);
                    continue block3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.monitor;
        synchronized (object) {
            StringBuilder result = new StringBuilder();
            for (BuildEnvironment env : this.slaves.keySet()) {
                for (String id : this.slaves.get(env).keySet()) {
                    result.append(env + " " + id + "\n");
                }
            }
            return result.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(String id) {
        Object object = this.monitor;
        synchronized (object) {
            return this.slaves.values().stream().flatMap(m -> m.keySet().stream()).anyMatch(otherId -> id.equals(otherId));
        }
    }

    public class RemoteSlaveLock
    implements AutoCloseable {
        public final String id;
        public final RemoteSlave slave;
        public final Capability capability;

        private RemoteSlaveLock(String id, RemoteSlave slave, Capability capability) {
            this.id = id;
            this.slave = slave;
            this.capability = capability;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object object = SlaveStore.this.monitor;
            synchronized (object) {
                SlaveStore.this.getLocks(this.id).remove(this);
                SlaveStore.this.monitor.notifyAll();
            }
        }

        @Override
        public void close() {
            this.release();
        }
    }
}

