/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BlameReport;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BlameReportProblem;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProject;
import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import at.jku.ssw.mevss.cerberus.ci.master.Project;
import at.jku.ssw.mevss.cerberus.ci.master.StorageListenerWrapper;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.Blamer;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.BuildError;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.TestFailure;
import at.jku.ssw.mevss.cerberus.ci.master.filetransfer.FileTransferServer;
import at.jku.ssw.mevss.cerberus.ci.master.storage.Storage;
import at.jku.ssw.mevss.cerberus.ci.master.storage.StorageListener;
import at.jku.ssw.mevss.cerberus.ci.shared.rmi.RemoteImpl;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RemoteProjectImpl
extends RemoteImpl<Project>
implements RemoteProject {
    private final Map<RemoteProject.Listener, StorageListener> listeners = Collections.synchronizedMap(new HashMap());

    public RemoteProjectImpl(Project project) {
        super(project);
    }

    @Override
    public String getName() {
        return ((Project)this.inner).getName();
    }

    @Override
    public BuildID[] getEnvironments() {
        return (BuildID[])Arrays.stream(((Project)this.inner).getEnvironments()).map(env -> new BuildID(env.os, env.arch, env.length)).toArray(BuildID[]::new);
    }

    @Override
    public String[] getFunctionalTests() {
        return ((Project)this.inner).getFunctionalTests();
    }

    @Override
    public String[] getPerformanceTests() {
        return ((Project)this.inner).getPerformanceTests();
    }

    @Override
    public BuildID[] getBuilds() {
        Storage storage = ((Project)this.inner).getStorage();
        ArrayList<BuildID> ids = new ArrayList<BuildID>();
        for (long build : ((Project)this.inner).getStorage().getBuilds()) {
            for (BuildEnvironment env : storage.getEnvironments(build)) {
                if (!((Project)this.inner).getStorage().getBuildLogFile(build, env).exists()) continue;
                ids.add(new BuildID(build, env.os, env.arch, env.length));
            }
        }
        return (BuildID[])ids.stream().sorted((a, b) -> a.compareTo((BuildID)b) * -1).toArray(BuildID[]::new);
    }

    @Override
    public BuildInfo getBuildInfo(BuildID identifier) throws RemoteException {
        return ((Project)this.inner).getBuildInfo(identifier.getID(), RemoteProjectImpl.createEnv(identifier));
    }

    @Override
    public BlameReport getBuildBlameReport(BuildID id) {
        BuildEnvironment env = RemoteProjectImpl.createEnv(id);
        ArrayList data = new ArrayList();
        Blamer.JudgementConsumer<BuildError> consumer = (author, problems) -> data.addAll(problems.entrySet().stream().filter(e -> ((BuildError)e.getKey()).env.equals(env)).map(e -> new BlameReportProblem(author, ((BuildError)e.getKey()).toString(), (String[])Arrays.stream((Object[])e.getValue()).map(c -> c.diff).toArray(String[]::new))).collect(Collectors.toList()));
        ((Project)this.inner).getBlamer().blameBuildErrors(id.getID(), null, consumer);
        return new BlameReport((BlameReportProblem[])data.stream().toArray(BlameReportProblem[]::new));
    }

    @Override
    public BlameReport getTestBlameReport(BuildID id, String test) {
        BuildEnvironment env = RemoteProjectImpl.createEnv(id);
        ArrayList data = new ArrayList();
        Blamer.JudgementConsumer<TestFailure> consumer = (author, problems) -> data.addAll(problems.entrySet().stream().filter(e -> ((TestFailure)e.getKey()).env.equals(env)).filter(e -> ((TestFailure)e.getKey()).test.equals(test)).map(e -> new BlameReportProblem(author, ((TestFailure)e.getKey()).toString(), (String[])Arrays.stream((Object[])e.getValue()).map(c -> c.diff).toArray(String[]::new))).collect(Collectors.toList()));
        ((Project)this.inner).getBlamer().blameTestFailures(id.getID(), null, consumer);
        return new BlameReport((BlameReportProblem[])data.stream().toArray(BlameReportProblem[]::new));
    }

    @Override
    public BlameReport getPerformanceTestBlameReport(BuildID id, String test) {
        BuildEnvironment env = RemoteProjectImpl.createEnv(id);
        ArrayList data = new ArrayList();
        Blamer.JudgementConsumer<TestFailure> consumer = (author, problems) -> data.addAll(problems.entrySet().stream().filter(e -> ((TestFailure)e.getKey()).env.equals(env)).filter(e -> ((TestFailure)e.getKey()).test.equals(test)).map(e -> new BlameReportProblem(author, ((TestFailure)e.getKey()).toString(), (String[])Arrays.stream((Object[])e.getValue()).map(c -> c.diff).toArray(String[]::new))).collect(Collectors.toList()));
        ((Project)this.inner).getBlamer().blamePerformanceTestFailures(id.getID(), null, consumer);
        return new BlameReport((BlameReportProblem[])data.stream().toArray(BlameReportProblem[]::new));
    }

    @Override
    public void addListener(RemoteProject.Listener l) {
        Thread.UncaughtExceptionHandler handler = (__0, __1) -> this.removeListener(l);
        StorageListenerWrapper wrapper = new StorageListenerWrapper(l, handler);
        this.listeners.put(l, wrapper);
        ((Project)this.inner).getStorage().addListener(wrapper);
    }

    @Override
    public void removeListener(RemoteProject.Listener l) {
        ((Project)this.inner).getStorage().removeListener(this.listeners.remove(l));
    }

    @Override
    public void runTask(String name, BuildID[] envs, String[] actions, boolean deploy) {
        ((Project)this.inner).beginRunTask(name, (BuildEnvironment[])Arrays.stream(envs).map(env -> new BuildEnvironment(env.getOS(), env.getArchitecture(), env.getAddressLength())).toArray(BuildEnvironment[]::new), actions, deploy);
    }

    @Override
    public int publishBuildLog(BuildID id) {
        File file = ((Project)this.inner).getStorage().getBuildLogFile(id.getID(), RemoteProjectImpl.createEnv(id));
        return ((Project)this.inner).getFileTransferServer().register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, file, null);
    }

    @Override
    public int publishBuild(BuildID id, String[] extensions) {
        File dir = ((Project)this.inner).getStorage().getBuildDirectory(id.getID(), RemoteProjectImpl.createEnv(id), false);
        if (!dir.exists()) {
            return 0;
        }
        return ((Project)this.inner).getFileTransferServer().register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, dir, extensions);
    }

    @Override
    public int publishTestLog(BuildID id, String test) {
        File file = ((Project)this.inner).getStorage().getTestLogFile(id.getID(), RemoteProjectImpl.createEnv(id), test);
        return ((Project)this.inner).getFileTransferServer().register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, file, null);
    }

    @Override
    public int publishTestData(BuildID id, String test) throws RemoteException {
        File file = ((Project)this.inner).getStorage().getTestDataFile(id.getID(), RemoteProjectImpl.createEnv(id), test);
        return ((Project)this.inner).getFileTransferServer().register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, file, null);
    }

    @Override
    public int publishTest(BuildID id, String test, String[] extensions) {
        File dir = ((Project)this.inner).getStorage().getTestDirectory(id.getID(), RemoteProjectImpl.createEnv(id), test, false);
        if (!dir.exists()) {
            return 0;
        }
        return ((Project)this.inner).getFileTransferServer().register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, dir, extensions);
    }

    private static BuildEnvironment createEnv(BuildID id) {
        return new BuildEnvironment(id.getOS(), id.getArchitecture(), id.getAddressLength());
    }

    @Override
    public boolean tryBlameAndNotify(long id, String suspect) {
        return ((Project)this.inner).blame(id, suspect);
    }

    @Override
    public int publishPerformanceTestLog(BuildID id, String testName) throws RemoteException {
        File file = ((Project)this.inner).getStorage().getPerformanceLogFile(id.getID(), RemoteProjectImpl.createEnv(id), testName);
        return ((Project)this.inner).getFileTransferServer().register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, file, null);
    }

    @Override
    public int publishPerformanceTestData(BuildID id, String testName) throws RemoteException {
        File file = ((Project)this.inner).getStorage().getPerformanceDataFile(id.getID(), RemoteProjectImpl.createEnv(id), testName);
        return ((Project)this.inner).getFileTransferServer().register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, file, null);
    }

    @Override
    public int publishPerformanceTest(BuildID id, String testName, String[] extensions) throws RemoteException {
        File dir = ((Project)this.inner).getStorage().getPerformanceDirectory(id.getID(), RemoteProjectImpl.createEnv(id), testName, false);
        if (!dir.exists()) {
            return 0;
        }
        return ((Project)this.inner).getFileTransferServer().register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, dir, extensions);
    }

    @Override
    public BuildID getLatestBuild(BuildID env) throws RemoteException {
        return Stream.of(this.getBuilds()).filter(x -> x.toEnv().equals(env.toEnv())).filter(x -> ((Project)this.inner).getBuildInfo(x.getID(), RemoteProjectImpl.createEnv(x)).getBuildResult() != null).sorted((a, b) -> a.getID() < b.getID() ? 1 : -1).findFirst().orElse(null);
    }

    @Override
    public BuildID getLatestBuildWithActionRun(BuildID env, Capability responsibility, String actionName) throws RemoteException {
        try {
            switch (responsibility) {
                case BUILD: {
                    return this.getLatestBuild(env);
                }
                case FUNCTIONAL_TEST: {
                    return Stream.of(this.getBuilds()).filter(x -> x.toEnv().equals(env.toEnv())).filter(build -> ((Project)this.inner).getBuildInfo(build.getID(), RemoteProjectImpl.createEnv(build)).getTestResults().get(actionName) != null).sorted((a, b) -> a.getID() < b.getID() ? 1 : -1).findFirst().orElse(null);
                }
                case PERFORMANCE_TEST: {
                    return Stream.of(this.getBuilds()).filter(x -> x.toEnv().equals(env.toEnv())).filter(x -> ((Project)this.inner).getBuildInfo(x.getID(), RemoteProjectImpl.createEnv(x)).getPerformanceTestResults().get(actionName) != null).sorted((a, b) -> a.getID() < b.getID() ? 1 : -1).findFirst().orElse(null);
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public BuildInfo getBuildInfo(long id, String os, String arch, int length) throws RemoteException {
        return ((Project)this.inner).getBuildInfo(id, new BuildEnvironment(os, arch, length));
    }

    @Override
    public int createActionUploadTicket(BuildID buildID, Capability responsibility, String actionName) throws RemoteException {
        return ((Project)this.inner).getPublisher().createActionDirectoryUploadTicket(buildID.getID(), BuildEnvironment.fromBuildID(buildID), responsibility, actionName);
    }

    @Override
    public boolean writeActionEntry(BuildID buildID, Capability responsibility, String actionName, boolean success) throws RemoteException {
        try {
            ((Project)this.inner).getStorage().writeActionEntry(buildID.getID(), BuildEnvironment.fromBuildID(buildID), responsibility, actionName, success);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public int createActionLogUploadTicket(BuildID buildID, Capability responsibility, String actionName) throws RemoteException {
        return ((Project)this.inner).getPublisher().createActionLogUploadTicket(buildID.getID(), BuildEnvironment.fromBuildID(buildID), responsibility, actionName);
    }

    @Override
    public int createActionDataUploadTicket(BuildID buildID, Capability responsibility, String actionName) throws RemoteException {
        return ((Project)this.inner).getPublisher().createActionDataUploadTicket(buildID.getID(), BuildEnvironment.fromBuildID(buildID), responsibility, actionName);
    }

    @Override
    public HashMap<BuildID, HashMap<String, BuildID>> getLatestBuilds(Capability capability) throws RemoteException {
        HashMap<BuildID, HashMap<String, BuildID>> result = new HashMap<BuildID, HashMap<String, BuildID>>();
        BuildID[] builds = this.getBuilds();
        for (BuildID env : this.getEnvironments()) {
            result.put(env, new HashMap());
            for (BuildID build2 : (BuildID[])Stream.of(builds).filter(build -> build.toEnv().equals(env)).toArray(BuildID[]::new)) {
                String[] testNames;
                Map<String, Boolean> tests = null;
                tests = capability == Capability.FUNCTIONAL_TEST ? ((Project)this.inner).getBuildInfo(build2.getID(), RemoteProjectImpl.createEnv(build2)).getTestResults() : ((Project)this.inner).getBuildInfo(build2.getID(), RemoteProjectImpl.createEnv(build2)).getPerformanceTestResults();
                for (String test2 : testNames = (String[])tests.entrySet().stream().filter(test -> test.getValue() != null).map(test -> (String)test.getKey()).toArray(String[]::new)) {
                    BuildID latestYet = result.get(env).get(test2);
                    if (latestYet == null) {
                        result.get(env).put(test2, build2);
                        continue;
                    }
                    if (build2.compareTo(latestYet) <= 0) continue;
                    result.get(env).put(test2, build2);
                }
            }
        }
        return result;
    }

    @Override
    public String[] getSchedule() throws RemoteException {
        return ((Project)this.inner).getScheduler().toString().split("\n");
    }

    @Override
    public String getRunningTask() throws RemoteException {
        return ((Project)this.inner).getRunningTask() == null ? null : ((Project)this.inner).getRunningTask().toString() + " (started at " + new Date(((Project)this.inner).getRunningTaskStartedAt()).toString() + ")";
    }
}

