/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteCallbackable;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteMaster;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProject;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemotePublisher;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteSlaveStore;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteTerminal;
import at.jku.ssw.mevss.cerberus.ci.master.Master;
import at.jku.ssw.mevss.cerberus.ci.master.MasterTerminal;
import at.jku.ssw.mevss.cerberus.ci.master.Project;
import at.jku.ssw.mevss.cerberus.ci.master.Publisher;
import at.jku.ssw.mevss.cerberus.ci.master.RemoteProjectImpl;
import at.jku.ssw.mevss.cerberus.ci.master.RemotePublisherImpl;
import at.jku.ssw.mevss.cerberus.ci.master.RemoteSlaveStoreImpl;
import at.jku.ssw.mevss.cerberus.ci.master.RemoteTerminalImpl;
import at.jku.ssw.mevss.cerberus.ci.shared.Version;
import at.jku.ssw.mevss.cerberus.ci.shared.rmi.RemoteImpl;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RemoteMasterImpl
extends RemoteImpl<Master>
implements RemoteMaster {
    private final long id;
    private final RemoteSlaveStoreImpl slave_store;
    private final Map<Project, RemoteProjectImpl> projects;
    private final Map<Publisher, RemotePublisherImpl> publishers;
    private final Master.Listener listener = new Master.Listener(){

        @Override
        public synchronized void projectRemoving(String name) {
            Project project = ((Master)RemoteMasterImpl.this.inner).getProject(name);
            Publisher publisher = project.getPublisher();
            if (publisher != null) {
                ((RemotePublisherImpl)RemoteMasterImpl.this.publishers.remove(publisher)).dispose();
            }
            ((RemoteProjectImpl)RemoteMasterImpl.this.projects.remove(project)).dispose();
        }

        @Override
        public synchronized void projectAdded(String name) {
            Project project = ((Master)RemoteMasterImpl.this.inner).getProject(name);
            RemoteMasterImpl.this.projects.put(project, new RemoteProjectImpl(project));
            Publisher publisher = project.getPublisher();
            if (publisher != null) {
                RemoteMasterImpl.this.publishers.put(publisher, new RemotePublisherImpl(publisher));
            }
        }
    };

    public RemoteMasterImpl(Master master, int port) throws SocketException {
        super(master, "CI_Master", port);
        this.id = System.currentTimeMillis();
        this.slave_store = new RemoteSlaveStoreImpl(master.getSlaveStore());
        this.projects = Collections.synchronizedMap(new HashMap());
        this.publishers = Collections.synchronizedMap(new HashMap());
        ((Master)this.inner).addListener(this.listener);
        for (Project project : master.getProjects()) {
            this.listener.projectAdded(project.getName());
        }
    }

    @Override
    public synchronized void dispose() {
        ((Master)this.inner).removeListener(this.listener);
        super.dispose();
        this.slave_store.dispose();
        this.projects.values().stream().forEach(p -> p.dispose());
        this.publishers.values().stream().forEach(p -> p.dispose());
    }

    @Override
    public String getVersion() {
        return Version.get();
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public RemoteTerminal createTerminal() {
        return new RemoteTerminalImpl(new MasterTerminal((Master)this.inner));
    }

    @Override
    public RemoteSlaveStore getSlaveStore() {
        return this.slave_store;
    }

    @Override
    public String[] getProjects() {
        return (String[])Arrays.stream(((Master)this.inner).getProjects()).map(project -> project.getName()).toArray(String[]::new);
    }

    @Override
    public RemoteProject getProject(String name) throws RemoteException {
        return this.projects.get(((Master)this.inner).getProject(name));
    }

    @Override
    public RemotePublisher getPublisher(String name) throws RemoteException {
        return this.publishers.get(((Master)this.inner).getProject(name).getPublisher());
    }

    @Override
    public int getFileServerPort() {
        return ((Master)this.inner).getFileServerPort();
    }

    @Override
    public boolean canCallback(RemoteCallbackable.RemoteCallback callback) {
        try {
            callback.call();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }
}

