/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigDirectory;
import at.jku.ssw.mevss.cerberus.ci.master.filetransfer.FileTransferServer;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.storage.Storage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Publisher {
    private final Logger logger;
    private final Storage storage;
    private final FileTransferServer fileTransferServer;

    public Publisher(String name, Storage storage, FileTransferServer server) {
        this.logger = Logger.getLogger("cerberus.publisher." + name);
        this.storage = storage;
        this.fileTransferServer = server;
    }

    public Map<BuildEnvironment, Long> getRevisions() {
        this.logger.info("resolving revisions");
        HashMap<BuildEnvironment, Long> revisions = new HashMap<BuildEnvironment, Long>();
        for (BuildEnvironment env : this.storage.getEnvironments()) {
            Long build = this.getNewestBuild(env);
            revisions.put(env, build);
        }
        this.logger.info("resolved revisions for " + revisions.size() + " environments");
        return revisions;
    }

    public Integer update(long id, BuildEnvironment env) {
        this.logger.info("updating to " + id + " on " + env);
        File dir = this.storage.getBuildDirectory(id, env, false);
        this.logger.info("registering new download");
        return this.fileTransferServer.register(FileTransferServer.Type.SINGLE_DOWNLOAD, null, dir, null);
    }

    private Long getNewestBuild(BuildEnvironment env) {
        try {
            long[] builds = this.storage.getBuilds();
            for (int build_index = builds.length - 1; build_index >= 0; --build_index) {
                long build = builds[build_index];
                Boolean result = this.storage.getBuildResult(build, env);
                if (result == null || !result.booleanValue()) continue;
                return build;
            }
            return null;
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "unexpected error", e);
            return null;
        }
    }

    public int publishBuild(long id, BuildEnvironment env) {
        File dir = this.storage.getBuildDirectory(id, env, false);
        if (!dir.exists()) {
            return -1;
        }
        return this.fileTransferServer.register(FileTransferServer.Type.SINGLE_DOWNLOAD, "", dir, null);
    }

    public int createActionDirectoryUploadTicket(long id, BuildEnvironment env, Capability responsibility, String actionName) {
        File dir = this.storage.getActionDirectory(id, env, responsibility, actionName, true);
        return this.fileTransferServer.register(FileTransferServer.Type.UPLOAD, null, dir, null);
    }

    public int publishFolder(File folder) {
        if (!folder.exists()) {
            return -1;
        }
        return this.fileTransferServer.register(FileTransferServer.Type.SINGLE_DOWNLOAD, "", folder, null);
    }

    int[] publishSource(ConfigDirectory[] srcs, Map<String, Repository> repos) {
        return this.publishSource(".", srcs, repos).stream().mapToInt(ticket -> ticket).toArray();
    }

    private List<Integer> publishSource(String prefix, ConfigDirectory[] srcs, Map<String, Repository> repos) {
        this.logger.fine("publishing source");
        ArrayList<Integer> tickets = new ArrayList<Integer>();
        for (ConfigDirectory src : srcs) {
            this.logger.finer("publishing source " + src.name);
            Repository repo = repos.get(src.name);
            if (repo == null) {
                throw new IllegalArgumentException("Cannot find repository associated with name '" + src.name + "' (url=" + src.url + ")!");
            }
            File dir = repo.getLocation();
            if (src.map != null) {
                dir = new File(dir + File.separator + src.map);
            }
            String innerPrefix = prefix + File.separator + src.name;
            tickets.add(this.fileTransferServer.register(FileTransferServer.Type.MULTI_DOWNLOAD, innerPrefix, dir, repo.getHiddenFilePrefix(), null));
            if (src.children == null) continue;
            tickets.addAll(this.publishSource(innerPrefix, src.children, repos));
        }
        return tickets;
    }

    public int createActionLogUploadTicket(long id, BuildEnvironment env, Capability responsibility, String actionName) {
        try {
            File file = this.storage.getActionLogFile(id, env, responsibility, actionName);
            if (!file.exists()) {
                file.createNewFile();
            }
            return this.fileTransferServer.register(FileTransferServer.Type.UPLOAD, null, file, null);
        }
        catch (FileNotFoundException e) {
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }

    public int createActionDataUploadTicket(long id, BuildEnvironment env, Capability responsibility, String actionName) {
        try {
            File file = this.storage.getActionDataFile(id, env, actionName, responsibility);
            if (!file.exists()) {
                file.createNewFile();
            }
            return this.fileTransferServer.register(FileTransferServer.Type.UPLOAD, null, file, null);
        }
        catch (FileNotFoundException e) {
            return -1;
        }
        catch (IOException e) {
            return -1;
        }
    }
}

