/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteBuildResult;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.SlaveClosedException;
import at.jku.ssw.mevss.cerberus.ci.master.Action;
import at.jku.ssw.mevss.cerberus.ci.master.BuildEnvironment;
import at.jku.ssw.mevss.cerberus.ci.master.Publisher;
import at.jku.ssw.mevss.cerberus.ci.master.SlaveStore;
import at.jku.ssw.mevss.cerberus.ci.master.blaming.Blamer;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigDeployment;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigDirectory;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigPerformance;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigProject;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigTest;
import at.jku.ssw.mevss.cerberus.ci.master.filetransfer.FileTransferServer;
import at.jku.ssw.mevss.cerberus.ci.master.mail.Notification;
import at.jku.ssw.mevss.cerberus.ci.master.repository.CerberusRepository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Change;
import at.jku.ssw.mevss.cerberus.ci.master.repository.DirectoryRepository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.MercurialRepository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.NoRepository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.Repository;
import at.jku.ssw.mevss.cerberus.ci.master.repository.RepositoryException;
import at.jku.ssw.mevss.cerberus.ci.master.repository.SubversionRepository;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.Clock;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.ReoccuringTask;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.Scheduler;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.SpecialTask;
import at.jku.ssw.mevss.cerberus.ci.master.schedule.Task;
import at.jku.ssw.mevss.cerberus.ci.master.storage.LogWriter;
import at.jku.ssw.mevss.cerberus.ci.master.storage.Storage;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.ManagedCall;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.process.NullProcessOutputListener;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessExecutor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Project
implements Closeable {
    private static final long REACTIVE_CHECK_INTERVAL = 600000L;
    private static final long REACTIVE_DELAY = 300000L;
    private static final long SLAVE_WAITING_DELAY = 21600000L;
    private static final long REPOSITORY_RETRIES = 5L;
    private final Logger logger;
    private final String name;
    private final File file;
    private final long revision;
    private final SlaveStore slaves;
    private final FileTransferServer fileTransfer;
    private final Map<BuildEnvironment, String[]> envs;
    private final Map<String, Action> actions;
    private final ConfigDeployment deployment;
    private final List<String> reactiveActions;
    private final ConfigDirectory[] src;
    private final ConfigDirectory working;
    private final Map<String, Repository> repositories;
    private final Storage storage;
    private final Notification notification;
    private final Blamer blamer;
    private final Publisher publisher;
    private final Object lock;
    private final Scheduler scheduler;
    private final Thread worker;
    private volatile boolean active;
    private volatile boolean running;
    private final File repositoriesPath;
    private Task runningTask;
    private long runningTaskStartedAt;

    public Project(ConfigProject config, File directory, String mailHost, File addresses, SlaveStore slaves, FileTransferServer fileTransfer) throws IOException {
        this.logger = Logger.getLogger("cerberus.project." + config.name);
        this.name = config.name;
        this.file = config.file;
        this.revision = config.revision;
        this.slaves = slaves;
        this.fileTransfer = fileTransfer;
        this.envs = Collections.unmodifiableMap(Project.createBuildCommands(config));
        this.actions = Collections.unmodifiableMap(Project.createActions(config));
        this.deployment = config.deploy != null ? config.deploy.clone() : null;
        this.reactiveActions = Collections.unmodifiableList(Project.createReactiveActions(config));
        this.src = ConfigDirectory.clone(config.src);
        this.logger.fine("initialized config directories");
        Stream.of(this.src).forEach(x -> this.logger.fine("\n" + x));
        this.repositoriesPath = new File(directory + File.separator + "repositories/");
        this.repositories = Collections.unmodifiableMap(Project.createRepositories(config, this.repositoriesPath));
        this.logger.fine("initialized repos");
        this.repositories.entrySet().forEach(e -> this.logger.fine((String)e.getKey() + " -> " + e.getValue()));
        this.storage = new Storage(new File(directory + File.separator + "storage"), this.getEnvironments(), config.capacity, config.history);
        this.notification = new Notification(this.name, mailHost, addresses);
        this.blamer = new Blamer(this.name, this.storage, this.repositories);
        this.publisher = new Publisher(this.name, this.storage, fileTransfer);
        this.lock = new Object();
        this.scheduler = new Scheduler(config.schedules);
        this.worker = new Thread(this::run, config.name + " Worker");
        this.working = config.getWorkingConfigDirectory();
        if (this.working == null) {
            this.active = false;
            this.running = false;
            this.logger.severe("Working directory could not be found. Master will not go active");
        } else {
            this.active = true;
        }
        this.runningTask = null;
        this.runningTaskStartedAt = 0L;
        this.logger.info("initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForIdle() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.running) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.logger.info("started");
        Object object = this.lock;
        synchronized (object) {
            this.running = true;
            this.worker.start();
        }
    }

    private static List<String> createReactiveActions(ConfigProject config) {
        return Arrays.asList(ArraysUtil.append(String.class, config.reactiveTests, config.reactivePerformances));
    }

    private static Map<BuildEnvironment, String[]> createBuildCommands(ConfigProject config) {
        return Arrays.stream(config.platforms).collect(Collectors.toMap(p -> new BuildEnvironment(p.os, p.architecture, p.addressLength), p -> p.buildCommand));
    }

    private static Map<String, Action> createActions(ConfigProject config) {
        HashMap<String, Action> actions = new HashMap<String, Action>();
        int id = 0;
        for (ConfigTest configTest : config.tests) {
            actions.put(configTest.name, new Action(id++, Capability.FUNCTIONAL_TEST, configTest.name, configTest.command));
        }
        for (ConfigPerformance configPerformance : config.performances) {
            actions.put(configPerformance.name, new Action(id++, Capability.PERFORMANCE_TEST, configPerformance.name, configPerformance.command));
        }
        return actions;
    }

    private static Map<String, Repository> createRepositories(ConfigProject config, File repoDirectory) {
        HashMap<String, Repository> repositories = new HashMap<String, Repository>();
        LinkedList<ConfigDirectory> queue = new LinkedList<ConfigDirectory>();
        queue.addAll(Arrays.asList(config.src));
        while (!queue.isEmpty()) {
            Repository repo;
            ConfigDirectory dir = (ConfigDirectory)queue.remove(0);
            if (dir.children != null) {
                queue.addAll(Arrays.asList(dir.children));
            }
            if ((repo = Project.createRepository(dir, repoDirectory)) == null) continue;
            repositories.put(repo.getName(), repo);
        }
        return repositories;
    }

    private static Repository createRepository(ConfigDirectory dir, File repoDirectory) {
        File location = new File(repoDirectory + File.separator + dir.name);
        switch (dir.type) {
            case "svn": {
                return new SubversionRepository(location, dir.name, dir.url, dir.map, dir.branch);
            }
            case "hg": {
                return new MercurialRepository(location, dir.name, dir.url, dir.map, dir.branch);
            }
            case "directory": {
                return new DirectoryRepository(location, dir.name, new File(dir.url));
            }
            case "cerberus": {
                return new CerberusRepository(location, dir.name, dir.url);
            }
            case "none": {
                return new NoRepository(location, dir.name);
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginClose() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                return false;
            }
            this.logger.info("beginning to close");
            this.active = false;
            this.lock.notifyAll();
            this.logger.info("began to close");
            return true;
        }
    }

    @Override
    public void close() throws InterruptedIOException {
        try {
            if (!this.beginClose()) {
                return;
            }
            this.logger.info("closing");
            this.worker.interrupt();
            this.worker.join();
            this.logger.info("closed");
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    public void join(long timeout) throws InterruptedException {
        this.worker.join(timeout);
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.file;
    }

    public long getRevision() {
        return this.revision;
    }

    public BuildEnvironment[] getEnvironments() {
        return (BuildEnvironment[])this.envs.keySet().stream().toArray(BuildEnvironment[]::new);
    }

    public String[] getFunctionalTests() {
        return Project.filterActions(this.actions.values().toArray(new Action[this.actions.size()]), Capability.FUNCTIONAL_TEST);
    }

    public String[] getPerformanceTests() {
        return Project.filterActions(this.actions.values().toArray(new Action[this.actions.size()]), Capability.PERFORMANCE_TEST);
    }

    private static String[] filterActions(Action[] actions, Capability capability) {
        return (String[])Stream.of(actions).filter(a -> a.capability == capability).map(a -> a.name).toArray(String[]::new);
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public Blamer getBlamer() {
        return this.blamer;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public FileTransferServer getFileTransferServer() {
        return this.fileTransfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginRunTask(String name, BuildEnvironment[] envs, String[] actions, boolean deploy) {
        if (name == null || name.length() == 0) {
            name = "manual";
        }
        Object object = this.lock;
        synchronized (object) {
            this.scheduler.put(new SpecialTask(name, envs, actions, deploy));
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        this.logger.info("running");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Task task;
                Object object = this.lock;
                synchronized (object) {
                    long now = Clock.time();
                    task = this.scheduler.next();
                    if (task == null) {
                        this.logger.fine("no task scheduled, waiting");
                    } else if (task != null && now < task.getTime()) {
                        this.logger.fine("next task is in the future (" + new Date(task.getTime()) + "), waiting");
                        this.scheduler.put(task);
                        task = null;
                    } else if (task != null && task.getTime() <= now) {
                        this.logger.fine("next task is in the past, executing");
                    } else {
                        assert (false) : "here be dragons";
                        continue;
                    }
                }
                if (task != null) {
                    this.run(task, this.blamer);
                    if (task.getType().isReoccuring) {
                        this.logger.fine("rescheduling task " + task);
                        object = this.lock;
                        synchronized (object) {
                            ((ReoccuringTask)task).reschedule();
                            this.scheduler.put(task);
                            continue;
                        }
                    }
                    this.logger.fine("disposing task " + task);
                    continue;
                }
                object = this.lock;
                synchronized (object) {
                    if (!this.active && !this.scheduler.containsSpecialTask()) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                }
                this.checkScheduleReactiveTask();
                object = this.lock;
                synchronized (object) {
                    task = this.scheduler.next();
                    long nextTaskTimespan = this.computeSleepTime(task);
                    if (task != null) {
                        this.scheduler.put(task);
                    }
                    if (nextTaskTimespan > 0L) {
                        long sleepTime = Math.min(nextTaskTimespan, 600000L);
                        this.logger.fine("next task scheduled in " + nextTaskTimespan / 1000L + "s");
                        this.logger.fine("sleeping for " + sleepTime / 1000L + "s");
                        this.running = false;
                        this.lock.notifyAll();
                        this.lock.wait(sleepTime);
                        this.running = true;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "unexpected error", t);
                this.notification.send(t);
            }
        }
        this.logger.info("terminated");
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.active = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkScheduleReactiveTask() {
        this.logger.fine("check if reactive task has to be executed");
        try {
            Object[] changed = this.updateRepositories(this.repositories, 5L);
            if (changed.length > 0) {
                this.logger.info("scheduling reactive task, repositories changed: " + Arrays.toString(changed));
                String name = "reactive (" + Arrays.stream(changed).map(r -> r.getName() + ":" + r.getRevisionNumber(this.logger)).reduce(null, (n1, n2) -> n1 == null ? n2 : n1 + ", " + n2) + ")";
                Object object = this.lock;
                synchronized (object) {
                    this.scheduler.put(new SpecialTask(name, null, ArraysUtil.append(String.class, this.reactiveActions.toArray(new String[0]), new String[0]), 300000L, false));
                    this.lock.notifyAll();
                }
                return true;
            }
            this.logger.fine("do not schedule reactive task, no repositories changed");
            return false;
        }
        catch (RepositoryException re) {
            this.logger.log(Level.WARNING, "error handling repositories, cannot determine whether a reactive task is necessary (" + re + ")");
            return false;
        }
    }

    private long computeSleepTime(Task task) throws InterruptedException {
        if (task != null) {
            long currentTime = Clock.time();
            if (task.getTime() <= currentTime) {
                return 0L;
            }
            return task.getTime() - currentTime;
        }
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(Task task, Blamer blamer) throws InterruptedException, IOException {
        int[] tickets;
        block13: {
            block14: {
                block11: {
                    block12: {
                        tickets = null;
                        try {
                            this.logger.info("running task " + task);
                            long id = Clock.time();
                            this.runningTask = task;
                            this.runningTaskStartedAt = id;
                            Action[] actions = (Action[])this.actions.values().stream().filter(a -> ArraysUtil.contains(task.getActions(), a.name)).toArray(Action[]::new);
                            this.updateRepositories(this.repositories, 5L);
                            Map<String, Long> revisions = this.getRepositoryRevisions(this.repositories);
                            BuildEnvironment[] envs = task.getEnvs();
                            if (envs == null) {
                                envs = this.getEnvironments();
                            }
                            if (task.getType() != Task.Type.SPECIAL && ((envs = this.filterEnvironmentsWithActions(envs, actions, revisions, this.repositories.values())) == null || envs.length == 0)) {
                                this.logger.info("aborting task " + task + " (no changes in repositories)");
                                if (tickets == null) break block11;
                                break block12;
                            }
                            this.storage.writeNewBuildMeta(id, revisions, task.getName(), envs, Project.filterActions(actions, Capability.FUNCTIONAL_TEST), Project.filterActions(actions, Capability.PERFORMANCE_TEST));
                            tickets = this.publisher.publishSource(this.src, this.repositories);
                            boolean deploy = task.includesDeploy();
                            int version_minor = deploy ? this.setVersion(false, 0) : this.setVersion(false, this.getVersion(false) + 1);
                            int version_major = deploy ? this.setVersion(true, this.getVersion(true) + 1) : this.getVersion(true);
                            Thread[] workers = this.startWorkers(id, tickets, envs, actions, task.includesDeploy(), version_major, version_minor);
                            this.joinWorkers(workers);
                            this.blame(id, null);
                            if (tickets == null) break block13;
                            break block14;
                        }
                        catch (RepositoryException re) {
                            this.logger.log(Level.WARNING, "error handling repositories, aborting and rescheduling tasks: " + re.getMessage());
                            Object object = this.lock;
                            synchronized (object) {
                                this.scheduler.put(task);
                                this.lock.notifyAll();
                                return;
                            }
                        }
                    }
                    this.unpublishSoure(tickets);
                }
                this.runningTask = null;
                this.runningTaskStartedAt = 0L;
                this.logger.info("finished task " + task);
                return;
            }
            this.unpublishSoure(tickets);
        }
        this.runningTask = null;
        this.runningTaskStartedAt = 0L;
        this.logger.info("finished task " + task);
        return;
        finally {
            if (tickets != null) {
                this.unpublishSoure(tickets);
            }
            this.runningTask = null;
            this.runningTaskStartedAt = 0L;
            this.logger.info("finished task " + task);
        }
    }

    private BuildEnvironment[] filterEnvironmentsWithActions(BuildEnvironment[] envs, Action[] actions, Map<String, Long> revisions, Collection<Repository> repositories) throws IOException {
        HashSet<BuildEnvironment> result = new HashSet<BuildEnvironment>();
        long[] builds = this.getBuildsWithCurrentSource(repositories);
        for (BuildEnvironment env : envs) {
            int founds = 0;
            block1: for (Action action : actions) {
                for (long build : builds) {
                    if ((action.capability != Capability.FUNCTIONAL_TEST || this.storage.getFunctionalTestResult(build, env, action.name) == null) && (action.capability != Capability.PERFORMANCE_TEST || this.storage.getPerformanceTestResult(build, env, action.name) == null)) continue;
                    ++founds;
                    continue block1;
                }
            }
            if (builds.length != 0 && founds >= actions.length) continue;
            result.add(env);
        }
        return result.toArray(new BuildEnvironment[result.size()]);
    }

    private long[] getBuildsWithCurrentSource(Collection<Repository> repositories) throws IOException {
        int lastDifferentIndex;
        long[] builds = this.storage.getBuilds();
        for (lastDifferentIndex = builds.length - 1; lastDifferentIndex >= 0 && this.isSameBuildSource(builds[lastDifferentIndex], repositories); --lastDifferentIndex) {
        }
        if (lastDifferentIndex < 0) {
            return builds;
        }
        long lastDifferentBuild = builds[lastDifferentIndex];
        return Arrays.stream(builds).filter(build -> build > lastDifferentBuild).toArray();
    }

    private boolean isSameBuildSource(long build, Collection<Repository> repositories) throws IOException {
        Map<String, Long> revisions = this.storage.getRevisions(build);
        for (Repository repository : repositories) {
            Change[] changes;
            long revision = repository.getRevisionNumber(this.logger);
            if (revision == revisions.get(repository.getName()) || (changes = repository.getChanges(revisions.get(repository.getName()), this.logger)) != null && changes.length <= 0) continue;
            return false;
        }
        return true;
    }

    private Repository[] updateRepositories(Map<String, Repository> repositories, long retries) {
        this.logger.fine("updating repositories");
        boolean parallel = true;
        List changed = Collections.synchronizedList(new ArrayList());
        class Result {
            public volatile Throwable exception = null;

            Result() {
            }
        }
        Result result = new Result();
        ArrayList<Thread> workers = new ArrayList<Thread>();
        Iterator<Repository> iterator = repositories.values().iterator();
        while (iterator.hasNext()) {
            Repository repo;
            Repository r = repo = iterator.next();
            Thread worker = new Thread(() -> {
                if (this.updateRepository(r, retries)) {
                    changed.add(r);
                }
            }, this.name + " " + repo.getName() + " Repository Worker");
            worker.setUncaughtExceptionHandler((t, e) -> {
                result.exception = e;
            });
            worker.start();
            workers.add(worker);
        }
        try {
            for (Thread worker : workers) {
                worker.join();
            }
        }
        catch (InterruptedException e2) {
            workers.stream().forEach(Thread::interrupt);
        }
        if (result.exception != null) {
            throw new RepositoryException(result.exception);
        }
        return (Repository[])changed.stream().toArray(Repository[]::new);
    }

    private boolean updateRepository(Repository repo, long retries) {
        this.logger.finer("updating repository " + repo.getName());
        int errors = 0;
        while (true) {
            try {
                boolean change = repo.update(this.logger);
                this.logger.finer("finished updating repository " + repo.getName() + ", found " + (change ? "" : "NO ") + "changes");
                return change;
            }
            catch (RepositoryException re) {
                this.logger.log(Level.WARNING, "updating " + repo.getName() + " failed, waiting and retrying (" + re + ")");
                if ((long)errors >= retries) {
                    FileUtil.deleteTree(repo.getLocation());
                    throw re;
                }
                try {
                    Thread.sleep((long)(60000.0 * Math.pow(2.0, errors++) * Math.random()));
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    private Map<String, Long> getRepositoryRevisions(Map<String, Repository> repositories) {
        this.logger.fine("getting current repository revisions");
        HashMap<String, Long> revisions = new HashMap<String, Long>();
        for (String name : repositories.keySet()) {
            this.logger.finer("getting current repository revision for " + name);
            Repository repo = repositories.get(name);
            long revision = repo.getRevisionNumber(this.logger);
            revisions.put(name, revision);
        }
        return revisions;
    }

    private void unpublishSoure(int[] tickets) throws InterruptedException {
        this.logger.fine("unpublishing sources");
        for (int ticket : tickets) {
            this.fileTransfer.unregister(ticket);
        }
    }

    private Thread[] startWorkers(long id, int[] tickets, BuildEnvironment[] envs, Action[] actions, boolean deploy, int version_major, int version_minor) {
        this.logger.fine("creating build workers");
        return (Thread[])Arrays.stream(envs).map(env -> this.startWorker(id, (BuildEnvironment)env, tickets, actions, deploy, version_major, version_minor)).toArray(Thread[]::new);
    }

    private Thread startWorker(long id, BuildEnvironment env, int[] tickets, Action[] actions, boolean deploy, int version_major, int version_minor) {
        this.logger.fine("creating build worker for " + env);
        Thread worker = new Thread(() -> this.run(id, env, tickets, actions, deploy, version_major, version_minor), id + " " + env.toString() + " Build Slave Worker");
        worker.start();
        return worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(long id, BuildEnvironment env, int[] tickets, Action[] actions, boolean deploy, int version_major, int version_minor) {
        Logger logger = Logger.getLogger(this.logger.getName() + "." + env.os + "." + env.arch + "." + env.length + "." + Capability.BUILD);
        try {
            logger.info("starting");
            RemoteBuildResult buildResult = this.runBuild(id, env, tickets, actions, version_major, version_minor, logger);
            if (buildResult != null) {
                buildResult.dispose();
                ArrayList<Thread> workers = new ArrayList<Thread>();
                for (Capability capability : new Capability[]{Capability.FUNCTIONAL_TEST, Capability.PERFORMANCE_TEST}) {
                    String[] capabilityactions = Project.filterActions(actions, capability);
                    if (capabilityactions.length <= 0) continue;
                    workers.add(this.startActionWorker(id, env, capability, (Action[])Stream.of(actions).filter(a -> ArraysUtil.contains(capabilityactions, a.name)).sorted().toArray(Action[]::new)));
                }
                this.joinWorkers(workers.toArray(new Thread[0]));
                if (this.storage.getBuildResult(id, env).booleanValue() && deploy) {
                    this.runDeployment(id, env, logger);
                }
            } else {
                logger.fine("build failed");
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "error in " + Thread.currentThread(), t);
            this.notification.send(t);
        }
        finally {
            logger.info("finished");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemoteBuildResult runBuild(long id, BuildEnvironment env, int[] tickets, Action[] actions, int version_major, int version_minor, Logger logger) throws InterruptedException, IOException {
        try (SlaveStore.RemoteSlaveLock slaveLock = this.slaves.aquire(env, Capability.BUILD, 21600000L);){
            RemoteBuildResult buildResult;
            if (slaveLock == null) {
                logger.warning("no slave found for build environment!");
                RemoteBuildResult remoteBuildResult2 = null;
                return remoteBuildResult2;
            }
            logger.fine("setting up upload of build");
            int ticket = this.fileTransfer.register(FileTransferServer.Type.UPLOAD, null, this.storage.getBuildDirectory(id, env, true), null);
            logger.fine("building (on remote slave)");
            try (LogWriter log = new LogWriter(this.storage.getBuildLogFile(id, env));){
                String[] command = ArraysUtil.append(String.class, (Object[])this.envs.get(env), Integer.toString(version_major), Integer.toString(version_minor));
                buildResult = ManagedCall.invokeAndCheck(RemoteBuildResult.class, SlaveClosedException.class, () -> slaveLock.slave.build(tickets, ticket, command, this.working.name, log), () -> slaveLock.slave.getID() != null, 600000L, 10);
            }
            this.storage.writeBuildEntry(id, env, buildResult != null);
            RemoteBuildResult remoteBuildResult = buildResult;
            return remoteBuildResult;
        }
        catch (SlaveClosedException | RemoteException e) {
            logger.info("slave closed right now, retrying ...");
            return this.runBuild(id, env, tickets, actions, version_major, version_minor, logger);
        }
    }

    private Thread startActionWorker(long id, BuildEnvironment env, Capability capability, Action[] actions) {
        Thread thread = new Thread(() -> this.runAction(id, env, capability, actions), id + " " + env.toString() + " " + capability + " Slave Worker");
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runAction(long id, BuildEnvironment env, Capability capability, Action[] actions) {
        int n;
        int n2;
        Action[] actionArray;
        RemoteBuildResult result;
        SlaveStore.RemoteSlaveLock slaveLock;
        Logger logger = Logger.getLogger(this.logger.getName() + "." + env.os + "." + env.arch + "." + env.length + "." + capability);
        logger.info("starting");
        try {
            slaveLock = this.slaves.aquire(env, capability, 21600000L);
            Throwable throwable = null;
            try {
                if (slaveLock == null) {
                    logger.warning("no slave found for " + capability + " environment!");
                    return;
                }
                int buildTicket = this.publisher.publishBuild(id, env);
                if (buildTicket == -1) {
                    logger.severe("Build could not be sent to slave because build-directory was not found on master");
                    return;
                }
                int[] workspaceTicket = this.publisher.publishSource(new ConfigDirectory[]{this.working}, this.repositories);
                if (workspaceTicket.length == 0) {
                    logger.severe("Build could not be sent to slave because workspace-directory was not found on master");
                    return;
                }
                result = slaveLock.slave.downloadBuildAndWorkingDir(buildTicket, workspaceTicket, this.working.name);
                if (result != null) {
                    logger.fine(capability + " (on remote slave)");
                    if (capability.isAsync()) {
                        this.slaves.unregister(slaveLock.id);
                        logger.finer("executing " + actions);
                        String[] names = new String[actions.length];
                        String[][] commands = new String[actions.length][];
                        int i = 0;
                        while (true) {
                            if (i >= names.length) {
                                result.executeActionAsync(this.name, id, capability, names, commands);
                                return;
                            }
                            Action action = actions[i];
                            names[i] = action.name;
                            commands[i] = action.command;
                            ++i;
                        }
                    }
                } else {
                    logger.fine("build failed");
                    return;
                }
                actionArray = actions;
                n2 = actionArray.length;
                n = 0;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (slaveLock != null) {
                    if (throwable != null) {
                        try {
                            slaveLock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        slaveLock.close();
                    }
                }
            }
        }
        catch (RemoteException e) {
            logger.log(Level.WARNING, "error in " + Thread.currentThread(), e);
            return;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "error in " + Thread.currentThread(), t);
            this.notification.send(t);
            return;
        }
        finally {
            logger.info("finished");
        }
        while (true) {
            if (n >= n2) {
                logger.fine("disposing (on remote slave)");
                result.dispose();
                return;
            }
            Action action = actionArray[n];
            logger.finer("executing " + action);
            int uploadTicket = this.publisher.createActionDirectoryUploadTicket(id, env, capability, action.name);
            try (LogWriter log = new LogWriter(this.storage.getActionLogFile(id, env, capability, action.name));
                 LogWriter data = new LogWriter(this.storage.getActionDataFile(id, env, action.name, capability));){
                Boolean success = ManagedCall.invokeAndCheck(Boolean.class, RemoteException.class, () -> result.executeAction(uploadTicket, action.name, action.command, log, data), () -> slaveLock.slave.getID() != null, 600000L, 10);
                this.storage.writeActionEntry(id, env, capability, action.name, success);
            }
            ++n;
        }
    }

    private void runDeployment(long id, BuildEnvironment env, Logger logger) throws IOException, InterruptedException {
        logger.fine("deploying");
        File working = this.deployment.location;
        boolean useTmp = false;
        if (!working.toString().equals(".")) {
            File source = this.repositories.get(working.toString()).getLocation();
            File dest = FileUtil.createTemporaryDirectory();
            ProcessExecutor.executeAndCheck(new File("."), false, "cp", "-r", source.toString(), dest.toString());
            working = new File(dest.toString() + File.separator + working.toString());
            useTmp = true;
        } else {
            working = new File(System.getProperty("user.home"));
        }
        ProcessExecutor.executeAndCheck(working, new NullProcessOutputListener(), new NullProcessOutputListener(), true, ArraysUtil.append(String.class, this.deployment.command, this.storage.getBuildDirectory(id, env, false).getAbsoluteFile().toString(), env.os, env.arch, String.valueOf(env.length)));
        if (useTmp) {
            FileUtil.deleteTree(working);
        }
    }

    private void joinWorkers(Thread[] workers) throws InterruptedException {
        this.logger.fine("waiting for workers");
        for (Thread worker : workers) {
            worker.join();
        }
    }

    public boolean blame(long id, String suspect) {
        this.logger.fine("blaming");
        return this.blamer.blame(id, suspect, (author, problems) -> this.notification.sendProblems(author, "Build error", problems, error -> error.env), (author, problems) -> this.notification.sendProblems(author, "Test failure", problems, failure -> failure.env));
    }

    public BuildInfo getBuildInfo(long id, BuildEnvironment env) {
        try {
            Storage storage = this.getStorage();
            String name = storage.getName(id);
            if (name == null) {
                return null;
            }
            Date time = storage.getTime(id);
            Boolean build = storage.getBuildResult(id, env);
            HashMap<String, Boolean> tests = new HashMap<String, Boolean>();
            for (String test : storage.getFunctionalTests(id)) {
                Boolean result = storage.getFunctionalTestResult(id, env, test);
                tests.put(test, result);
            }
            HashMap<String, Boolean> performanceTests = new HashMap<String, Boolean>();
            for (String test : storage.getPerformanceTests(id)) {
                Boolean result = storage.getPerformanceTestResult(id, env, test);
                performanceTests.put(test, result);
            }
            return new BuildInfo(name, time, build, tests, performanceTests);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Task getRunningTask() {
        return this.runningTask;
    }

    public long getRunningTaskStartedAt() {
        return this.runningTaskStartedAt;
    }

    public int getVersion(boolean major) throws IOException {
        File file = this.getVersionFile(major);
        if (!file.exists()) {
            this.setVersion(major, 0);
        }
        return Integer.parseInt(FileUtil.read(file).trim());
    }

    public int setVersion(boolean major, int version) throws IOException {
        FileUtil.write(this.getVersionFile(major), Integer.toString(version));
        return version;
    }

    public File getVersionFile(boolean major) {
        return new File(this.repositoriesPath + File.separator + "version." + (major ? "major" : "minor"));
    }
}

