/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.master.Master;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class MasterTerminal {
    private final Logger LOGGER = Logger.getLogger("cerberus.master.terminal");
    private final Master master;

    public MasterTerminal(Master master) {
        this.master = master;
    }

    public String execute(String command) {
        try {
            String[] tokens = (String[])Arrays.stream(command.split(" ")).filter(t -> t.length() > 0).toArray(String[]::new);
            String cmd = tokens[0];
            String[] args = ArraysUtil.subarray(tokens, 1, tokens.length, String[]::new);
            switch (cmd) {
                case "quit": {
                    ((Stream)Arrays.stream(this.master.getProjects()).parallel()).filter(p -> p.isRunning()).forEach(p -> {
                        try {
                            p.waitForIdle();
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    });
                    this.master.close(0L);
                    return null;
                }
                case "dump-slaves": {
                    return this.master.getSlaveStore().toString();
                }
                case "dump-schedule": {
                    return this.master.getProject(args[0]).getScheduler().toString();
                }
                case "dump-storage": {
                    return this.master.getProject(args[0]).getStorage().toString();
                }
                case "delete-build": {
                    this.master.getProject(args[0]).getStorage().getDirectory(Long.parseLong(args[1]));
                    return null;
                }
            }
            this.LOGGER.log(Level.WARNING, "unknown command: " + cmd);
            return "unknown command: " + cmd;
        }
        catch (Throwable e) {
            this.LOGGER.log(Level.SEVERE, "unexpected error", e);
            return e.toString();
        }
    }
}

