/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.master.Project;
import at.jku.ssw.mevss.cerberus.ci.master.SlaveStore;
import at.jku.ssw.mevss.cerberus.ci.master.config.ConfigProject;
import at.jku.ssw.mevss.cerberus.ci.master.filetransfer.FileTransferServer;
import at.jku.ssw.mevss.cerberus.ci.shared.Version;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Master
implements AutoCloseable {
    private final Logger logger = Logger.getLogger("cerberus.master");
    private final Object lock;
    private final File data;
    private final String mailHost;
    private final File addresses;
    private final FileTransferServer fileTransfer;
    private final SlaveStore slaves;
    private final List<Listener> listeners;
    private final Map<String, Project> projects;
    private final Thread worker;
    private volatile boolean active;

    public Master(int fileTransferPort, File data, String mailHost, File addresses, File[] configs) throws IOException {
        this.logger.info("booting (version " + Version.get() + ")");
        this.lock = new Object();
        this.data = data;
        this.mailHost = mailHost;
        this.addresses = addresses;
        this.logger.info("creating file transfer server");
        this.fileTransfer = new FileTransferServer(fileTransferPort);
        this.logger.info("creating slave store");
        this.slaves = new SlaveStore();
        this.logger.info("creating projects");
        this.listeners = Collections.synchronizedList(new CopyOnWriteArrayList());
        this.projects = Collections.synchronizedMap(new HashMap());
        try {
            for (int i = 0; i < configs.length; ++i) {
                this.loadProject(configs[i]);
            }
        }
        catch (IOException iae) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(iae);
        }
        this.worker = new Thread(this::run, "Master Worker");
        this.active = true;
        this.logger.info("ready");
    }

    public void start() {
        this.logger.info("starting projects");
        for (Project project : this.projects.values()) {
            project.start();
        }
        this.worker.start();
    }

    @Override
    public void close() throws Exception {
        this.close(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeout) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.active) {
                return;
            }
            this.logger.info("closing");
            this.worker.interrupt();
            for (Project project : this.projects.values()) {
                project.beginClose();
            }
            if (timeout > 0L) {
                for (Project project : this.projects.values()) {
                    long start = System.currentTimeMillis();
                    project.join(timeout);
                    long closeTime = System.currentTimeMillis() - start;
                    if ((timeout -= closeTime) > 0L) continue;
                    break;
                }
                for (Project project : this.projects.values()) {
                    project.close();
                }
            } else if (timeout == 0L) {
                for (Project project : this.projects.values()) {
                    project.join(0L);
                }
            } else if (timeout < 0L) {
                for (Project project : this.projects.values()) {
                    project.close();
                }
            } else assert (false);
            for (Project project : this.projects.values()) {
                this.listeners.stream().forEach(l -> l.projectRemoving(project.getName()));
            }
            this.projects.clear();
            this.fileTransfer.close();
            this.active = false;
            this.lock.notifyAll();
            this.logger.info("closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.active) {
                this.lock.wait();
            }
        }
    }

    public SlaveStore getSlaveStore() {
        return this.slaves;
    }

    public Project[] getProjects() {
        return (Project[])this.projects.values().stream().toArray(Project[]::new);
    }

    public Project getProject(String name) {
        return this.projects.get(name);
    }

    public int getFileServerPort() {
        return this.fileTransfer.getPort();
    }

    public void addListener(Listener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeListener(Listener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProject(File file) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.logger.info("setting up project from " + file);
            ConfigProject config = ConfigProject.parseConfig(file);
            if (this.projects.containsKey(config.name)) {
                throw new IOException("Cannot host two projects with the same name! (" + config.name + ")");
            }
            Project project = new Project(config, new File(this.data + File.separator + config.name), this.mailHost, this.addresses, this.slaves, this.fileTransfer);
            this.projects.put(project.getName(), project);
            this.listeners.stream().forEach(l -> l.projectAdded(project.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadProject(String name, long timeout) {
        Object object = this.lock;
        synchronized (object) {
            Project project = this.projects.get(name);
            if (project == null) {
                throw new IllegalArgumentException("No such project: " + name);
            }
            try {
                project.beginClose();
                project.join(timeout);
                this.listeners.stream().forEach(l -> l.projectRemoving(name));
                this.projects.remove(name);
                ConfigProject config = ConfigProject.parseConfig(project.getFile());
                Project newProject = new Project(config, new File(project.getStorage().getBase() + File.separator + ".."), this.mailHost, this.addresses, this.slaves, this.fileTransfer);
                this.projects.put(newProject.getName(), newProject);
                this.listeners.stream().forEach(l -> l.projectAdded(newProject.getName()));
                newProject.start();
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "could not reload project", e);
            }
        }
    }

    private void run() {
        Thread self = Thread.currentThread();
        assert (this.worker == self);
        while (!self.isInterrupted()) {
            try {
                for (Project project : new HashSet<Project>(this.projects.values())) {
                    if (project.getRevision() >= project.getFile().lastModified()) continue;
                    this.reloadProject(project.getName(), 0L);
                }
                Thread.sleep(3600000L);
            }
            catch (InterruptedException ie) {
                self.interrupt();
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "unexpected error", t);
            }
        }
    }

    public static interface Listener {
        public void projectRemoving(String var1);

        public void projectAdded(String var1);
    }
}

