/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.master.Master;
import at.jku.ssw.mevss.cerberus.ci.master.RemoteMasterImpl;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    public static void main(String[] args) {
        int port = Integer.parseInt(args[0]);
        File data = new File(args[1]);
        String mailHost = args[2];
        File addresses = new File(args[3]);
        File[] projects = (File[])Arrays.stream(args, 4, args.length).map(name -> new File((String)name)).toArray(File[]::new);
        Main.main(port, data, mailHost, addresses, projects);
    }

    public static void main(int port, File data, String mailHost, File addresses, File ... projects) {
        boolean ok;
        try (Master master = new Master(port + 1, data, mailHost, addresses, projects);){
            try (RemoteMasterImpl remoteMaster = new RemoteMasterImpl(master, port);){
                master.start();
                master.join();
            }
            ok = true;
        }
        catch (Throwable t) {
            Logger.getLogger("cerberus.master").log(Level.SEVERE, "internal error", t);
            ok = false;
        }
        System.exit(ok ? 0 : 1);
    }
}

