/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.master;

import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import java.util.HashMap;
import java.util.Map;

public class BuildEnvironment {
    private static final Map<String, String> OS = new HashMap<String, String>();
    private static final Map<String, String> ARCH = new HashMap<String, String>();
    public final String os;
    public final String arch;
    public final int length;

    public BuildEnvironment(String os, String arch, int length) {
        this.os = OS.containsKey(os) ? OS.get(os) : os;
        this.arch = ARCH.containsKey(arch) ? ARCH.get(arch) : arch;
        this.length = length;
    }

    public static BuildEnvironment fromBuildID(BuildID buildID) {
        return new BuildEnvironment(buildID.getOS(), buildID.getArchitecture(), buildID.getAddressLength());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        BuildEnvironment that = (BuildEnvironment)other;
        return this.os.equals(that.os) && this.arch.equals(that.arch) && this.length == that.length;
    }

    public int hashCode() {
        return this.os.hashCode() ^ this.arch.hashCode() ^ this.length;
    }

    public String toString() {
        return this.os + " " + this.arch + " " + this.length;
    }

    static {
        ARCH.put("amd64", "x86_64");
    }
}

