/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared.io;

import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import java.io.File;
import java.io.FilePermission;
import java.security.Permission;
import java.util.Arrays;

public class RecursiveFilePermission
extends Permission {
    private static final long serialVersionUID = 1270964336159091593L;
    private final String[] actions;

    public RecursiveFilePermission(String root, String actions) {
        super(root);
        this.actions = (String[])Arrays.stream(actions.split(",")).map(a -> a.trim()).filter(a -> a.length() > 0).distinct().sorted().toArray(String[]::new);
        System.out.println(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        RecursiveFilePermission that = (RecursiveFilePermission)obj;
        return this.getName().equals(that.getName()) && Arrays.equals(this.actions, that.actions);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() ^ Arrays.hashCode(this.actions);
    }

    @Override
    public String getActions() {
        return Arrays.stream(this.actions).reduce((a1, a2) -> a1 + "," + a2).orElse("");
    }

    @Override
    public boolean implies(Permission permission) {
        System.out.println(this + " =?> " + permission);
        if (permission instanceof FilePermission) {
            FilePermission that = (FilePermission)permission;
            File root = new File(this.getName()).getAbsoluteFile();
            File file = new File(that.getName()).getAbsoluteFile();
            return file.toString().startsWith(root.toString()) && Arrays.stream(that.getActions().split(",")).allMatch(action -> ArraysUtil.contains(this.actions, action));
        }
        if (permission instanceof RecursiveFilePermission) {
            RecursiveFilePermission that = (RecursiveFilePermission)permission;
            return Arrays.equals(this.actions, that.actions) && that.getName().startsWith(this.getName());
        }
        return false;
    }

    public static void main(String[] args) {
        RecursiveFilePermission actual = new RecursiveFilePermission("a/b/c", "read,write");
        System.err.println(actual.implies(new FilePermission("a/b/c", "write")));
        System.err.println(actual.implies(new FilePermission("a/b/c/", "write")));
        System.err.println(actual.implies(new FilePermission("a/b/c/d", "write")));
    }
}

