/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared;

import java.rmi.RemoteException;

public class ManagedCall {
    public static <E extends Exception> void invokeAndRetry(Class<E> exceptionClass, ProcedureCall<E> function, long retryInterval, int retries) throws E, RemoteException, InterruptedException {
        ManagedCall.invokeAndRetry(Void.class, exceptionClass, () -> {
            function.execute();
            return null;
        }, retryInterval, retries);
    }

    public static <R, E extends Exception> R invokeAndRetry(Class<R> resultClass, Class<E> exceptionClass, FunctionCall<R, E> function, long retryInterval, int retries) throws E, RemoteException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                return function.execute();
            }
            catch (RemoteException re) {
                if (count++ >= retries) {
                    throw re;
                }
                Thread.sleep(retryInterval);
                continue;
            }
            break;
        }
    }

    public static <R, E extends Exception> R invokeAndCheck(Class<R> resultClass, Class<E> exceptionClass, FunctionCall<R, E> function, FunctionCall<Boolean, E> check, long interval, int checks) throws E, RemoteException, InterruptedException {
        ResultContainer result = new ResultContainer();
        Thread thread = new Thread(() -> {
            try {
                result.value = function.execute();
            }
            catch (Throwable exception) {
                result.exception = exception;
            }
            finally {
                result.done = true;
            }
        });
        thread.setDaemon(true);
        thread.start();
        int fails = 0;
        while (!result.done) {
            if (fails >= checks) {
                throw new RemoteException("Timeout");
            }
            fails = ManagedCall.check(check).booleanValue() ? 0 : ++fails;
            thread.join(interval / (long)checks);
        }
        if (result.exception == null) {
            return result.value;
        }
        if (exceptionClass.isInstance(result.exception)) {
            throw (Exception)result.exception;
        }
        if (result.exception instanceof RemoteException) {
            throw new RemoteException(result.exception.getMessage(), result.exception);
        }
        throw new RuntimeException(result.exception);
    }

    private static <E extends Exception> Boolean check(FunctionCall<Boolean, E> check) {
        try {
            return check.execute();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static class ResultContainer<R, E extends Exception> {
        public boolean done;
        public R value;
        public Throwable exception;

        private ResultContainer() {
        }
    }

    public static interface ProcedureCall<E extends Exception> {
        public void execute() throws RemoteException, E;
    }

    public static interface FunctionCall<R, E extends Exception> {
        public R execute() throws RemoteException, E;
    }
}

