/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared;

import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.io.PipeInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommandInterpreter
implements AutoCloseable {
    private final String name;
    private final Logger logger;
    private final File file;
    private final Thread worker;

    public CommandInterpreter(String name) throws IOException {
        this.name = name;
        this.logger = Logger.getLogger("cerberus.commandinterpreter." + name);
        File dir = new File(System.getProperty("user.home") + File.separator + ".cerberus_command_pipes");
        dir.mkdirs();
        this.file = new File(dir + File.separator + name);
        this.worker = new Thread(this::run);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void run() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new PipeInputStream(this.file, true)));){
            String line = in.readLine();
            while (line != null) {
                String l = line;
                new Thread(() -> this.executeSavely(l), CommandInterpreter.class.getSimpleName() + " " + this.name + ": " + line).start();
                line = in.readLine();
            }
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, "unexpected error", ioe);
        }
    }

    private void executeSavely(String line) {
        try {
            this.logger.info("executing \"" + line + "\"");
            String[] tokens = line.split(" ");
            String command = tokens[0];
            String[] args = ArraysUtil.subarray(tokens, 1, tokens.length, String[]::new);
            this.execute(command, args);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "unexpected error occoured executing command \"" + line + "\"", e);
        }
    }

    protected abstract void execute(String var1, String[] var2) throws Exception;

    @Override
    public void close() throws IOException {
        this.worker.interrupt();
    }
}

