/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.updater;

import at.jku.ssw.mevss.cerberus.ci.interfaces.filetransfer.FileTransferProtocol;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteMaster;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemotePublisher;
import at.jku.ssw.mevss.cerberus.ci.shared.ArraysUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.io.FileUtil;
import at.jku.ssw.mevss.cerberus.ci.shared.net.InterruptableSocket;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Updater {
    private final File location;
    private final Logger logger;
    private final String name;

    public Updater(String name, File location) {
        this.location = location;
        this.name = name;
        this.logger = Logger.getLogger("cerberus.updater." + name);
    }

    public long getRevisionNumber() throws IOException {
        this.logger.info("calculating local revision number");
        long revision = Arrays.stream(this.getMetaDirectory().listFiles()).filter(f -> f.getName().startsWith("revision_")).map(f -> FileUtil.readSilently(f)).filter(c -> c != null).map(c -> c.trim()).mapToLong(c -> Long.parseLong(c)).max().orElse(0L);
        this.logger.info("calculated local revision number as " + revision);
        return revision;
    }

    public void checkout(String url) throws IOException {
        this.logger.info("initial checking out " + this.name);
        FileUtil.write(this.getMetaFile(), new ConnectionData(url).toString().trim());
        this.logger.info("initially checked out " + this.name);
    }

    public boolean update() throws IOException {
        try {
            this.logger.info("updating " + this.name);
            ConnectionData data = new ConnectionData(FileUtil.read(this.getMetaFile()));
            int changes = 0;
            this.logger.fine("connecting to master");
            RemoteMaster master = this.getMaster(data.host, data.port);
            RemotePublisher publisher = master.getPublisher(data.project);
            if (publisher == null) {
                throw new RemoteException("Cannot access " + data.project + " although server is reachable, is it not published?");
            }
            this.logger.fine("fetching remote revisions");
            BuildID[] revisions = publisher.getRevisions();
            this.logger.fine("fetched " + revisions.length + " revisions");
            revisions = (BuildID[])Arrays.stream(revisions).filter(r -> data.os.length == 0 || ArraysUtil.contains(data.os, r.getOS())).filter(r -> data.arch.length == 0 || ArraysUtil.contains(data.arch, r.getArchitecture())).filter(r -> data.length.length == 0 || ArraysUtil.contains(data.length, r.getAddressLength())).toArray(BuildID[]::new);
            this.logger.fine("selected " + revisions.length + " revisions");
            for (BuildID revision : revisions) {
                long remoteRevision = revision.getID();
                if (remoteRevision == 0L) {
                    throw new IOException("Data for environment " + revision.toEnv() + " is unavailable!");
                }
                Long localRevision = this.getLocalRevision(revision.toEnv());
                this.logger.finer("environment " + revision.toEnv() + " has remote revision " + remoteRevision + " and " + (localRevision != null ? "local revision " + localRevision : "no local revision"));
                if (localRevision != null && localRevision >= remoteRevision) continue;
                ++changes;
            }
            if (changes > 0) {
                FileUtil.deleteTree(this.location);
                this.location.mkdirs();
                FileUtil.write(this.getMetaFile(), data.toString().trim());
                for (BuildID revision : revisions) {
                    this.logger.finer("updating");
                    int ticket = publisher.update(revision);
                    this.logger.finer("downloading");
                    this.download(data.host, master.getFileServerPort(), ticket, data.flat ? this.location : new File(this.location + File.separator + revision.toEnv()));
                    this.logger.finer("storing remote revision as local");
                    FileUtil.write(this.getRevisionFile(revision.toEnv()), String.valueOf(revision.getID()));
                }
            }
            this.logger.info("updated (found " + changes + " changes)");
            return changes > 0;
        }
        catch (ConnectException ce) {
            this.logger.info("repository not reachable");
            throw new IOException(ce.getMessage(), ce);
        }
        catch (RemoteException re) {
            this.logger.log(Level.SEVERE, "unexpected error", re);
            throw new IOException(re.getMessage(), re);
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, "unexpected error", ioe);
            throw ioe;
        }
        catch (NullPointerException npe) {
            this.logger.log(Level.SEVERE, "unexpected error", npe);
            throw npe;
        }
    }

    private void download(String host, int port, int ticket, File dest) throws UnknownHostException, IOException {
        try (InterruptableSocket socket = new InterruptableSocket(host, port, 10000);){
            ObjectOutputStream out = new ObjectOutputStream(socket.getOutputStream());
            ObjectInputStream in = new ObjectInputStream(((Socket)socket).getInputStream());
            out.writeInt(ticket);
            out.flush();
            new FileTransferProtocol(String.valueOf(ticket)).read(null, dest, in);
            out.close();
            in.close();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private RemoteMaster getMaster(String host, int port) throws RemoteException {
        try {
            return (RemoteMaster)LocateRegistry.getRegistry(host, port).lookup("CI_Master");
        }
        catch (NotBoundException nbe) {
            throw new RemoteException("Found remote registry, but cannot find master!");
        }
    }

    private Long getLocalRevision(BuildID env) throws IOException {
        String revision = FileUtil.read(this.getRevisionFile(env));
        return revision != null ? Long.valueOf(Long.parseLong(revision.trim())) : null;
    }

    private File getMetaFile() {
        return new File(this.getMetaDirectory() + File.separator + "meta");
    }

    private File getRevisionFile(BuildID env) {
        return new File(this.getMetaDirectory() + File.separator + "revision_" + env.toEnv());
    }

    private File getMetaDirectory() {
        File file = new File(this.location + File.separator + ".cerberus");
        file.mkdirs();
        return file;
    }

    private static class ConnectionData {
        public final String host;
        public final int port;
        public final String project;
        public final boolean flat;
        public final String[] os;
        public final String[] arch;
        public final int[] length;

        public ConnectionData(String url) {
            this(url.trim().split(":"));
        }

        private ConnectionData(String[] tokens) {
            this(tokens[0], Integer.parseInt(tokens[1]), tokens[2], tokens[3].equalsIgnoreCase("flat"), (String[])Arrays.stream(tokens).filter(t -> t.startsWith("os=")).map(t -> t.substring(t.indexOf("=") + 1, t.length())).toArray(String[]::new), (String[])Arrays.stream(tokens).filter(t -> t.startsWith("arch=")).map(t -> t.substring(t.indexOf("=") + 1, t.length())).toArray(String[]::new), Arrays.stream(tokens).filter(t -> t.startsWith("length=")).map(t -> t.substring(t.indexOf("=") + 1, t.length())).mapToInt(l -> Integer.parseInt(l)).toArray());
        }

        public ConnectionData(String host, int port, String project, boolean flat, String[] os, String[] arch, int[] length) {
            this.host = host;
            this.port = port;
            this.project = project;
            this.flat = flat;
            this.os = os;
            this.arch = arch;
            this.length = length;
        }

        public String toString() {
            return this.host + ":" + this.port + ":" + this.project + ":" + (this.flat ? "flat" : "deep") + Arrays.stream(this.os).map(n -> ":os=" + n).reduce("", (t1, t2) -> t1 + t2) + Arrays.stream(this.arch).map(n -> ":arch=" + n).reduce("", (t1, t2) -> t1 + t2) + Arrays.stream(this.length).mapToObj(l -> ":length=" + l).reduce("", (t1, t2) -> t1 + t2);
        }
    }
}

