/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared.rmi;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.rmi.AlreadyBoundException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RemoteImpl<I>
implements Remote,
AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger("cerberus.rmi");
    protected final I inner;
    private final String name;
    private final int port;

    private static String getHostName() throws SocketException {
        ArrayList<String> candidates = new ArrayList<String>();
        for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (iface.isLoopback() || !iface.isUp()) continue;
            for (InetAddress addr : Collections.list(iface.getInetAddresses())) {
                String candidate = addr.getCanonicalHostName();
                LOGGER.config("host_name_candidate=" + candidate);
                candidates.add(candidate);
            }
        }
        String host = candidates.stream().filter(h -> !h.contains(":")).distinct().sorted((h1, h2) -> h2.length() - h1.length()).findFirst().orElse("127.0.0.1");
        LOGGER.config("host_name=" + host);
        return host;
    }

    protected RemoteImpl(I inner) {
        this(inner, null, 0);
    }

    protected RemoteImpl(I inner, String name, int port) {
        this.inner = inner;
        this.name = name;
        this.port = port;
        try {
            this.init();
        }
        catch (RemoteException e) {
            LOGGER.log(Level.SEVERE, "cannot export object to " + name);
            throw new RuntimeException(e);
        }
    }

    private void init() throws RemoteException {
        UnicastRemoteObject.exportObject((Remote)this, 0);
        if (this.name != null) {
            try {
                RemoteImpl.getRegistry(this.port).bind(this.name, this);
                LOGGER.info("bound object " + this.name + " in registry at " + this.port);
            }
            catch (AlreadyBoundException e) {
                LOGGER.log(Level.SEVERE, "cannot bind object to " + this.name);
                this.dispose();
                throw new RemoteException(e.getMessage(), e);
            }
        }
    }

    private static Registry getRegistry(int port) throws RemoteException {
        try {
            return LocateRegistry.createRegistry(port);
        }
        catch (RemoteException e) {
            return LocateRegistry.getRegistry(port);
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void dispose() {
        try {
            if (this.name != null) {
                LocateRegistry.getRegistry(this.port).unbind(this.name);
            }
        }
        catch (NotBoundException | RemoteException e) {
            LOGGER.log(Level.WARNING, "cannot unbind object from " + this.name);
        }
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException e) {
            LOGGER.log(Level.WARNING, "cannot unexport object: " + e);
        }
    }

    static {
        try {
            System.setProperty("java.rmi.server.useLocalHostname", Boolean.TRUE.toString());
            System.setProperty("java.rmi.server.hostname", RemoteImpl.getHostName());
            System.setProperty("java.rmi.dgc.leaseValue", String.valueOf(21600000L));
            System.setProperty("sun.rmi.transport.connectionTimeout", String.valueOf(300000L));
            System.setProperty("sun.rmi.transport.tcp.handshakeTimeout", String.valueOf(300000L));
            System.setProperty("sun.rmi.transport.tcp.responseTimeout", "0");
            System.setProperty("sun.rmi.dgc.ackTimeout", String.valueOf(300000L));
        }
        catch (SocketException e) {
            LOGGER.log(Level.SEVERE, "error occoured", e);
        }
    }
}

