/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.shared.process;

import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessOutputListener;
import at.jku.ssw.mevss.cerberus.ci.shared.process.ProcessOutputRedirector;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

public class ProcessExecutor {
    public static void executeAndCheck(File location, boolean log, String ... command) throws IOException, InterruptedException {
        ProcessExecutor.executeAndCheck(location, s -> {}, (String s) -> {}, log, command);
    }

    public static int execute(File directory, boolean log, String ... command) throws IOException, InterruptedException {
        return ProcessExecutor.execute(directory, s -> {}, (String s) -> {}, log, command);
    }

    public static void executeAndCheck(File directory, ProcessOutputListener out, ProcessOutputListener err, boolean log, String ... command) throws IOException, InterruptedException {
        int exit = ProcessExecutor.execute(directory, out, err, log, command);
        if (exit != 0) {
            throw new IOException("Process terminated unexpectedly!");
        }
    }

    public static int execute(File directory, ProcessOutputListener out, ProcessOutputListener err, boolean log, String ... command) throws IOException, InterruptedException {
        if (log) {
            String loggerName = "cerberus.process." + Arrays.toString(command).replace(", ", " ") + " @ " + directory;
            Logger logger = Logger.getLogger(loggerName);
            ProcessOutputListener innerOut = out;
            ProcessOutputListener innerErr = err;
            out = line -> {
                logger.info(line);
                innerOut.log(line);
            };
            err = line -> {
                logger.info(line);
                innerErr.log(line);
            };
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(directory);
        builder.command(command);
        Process process = builder.start();
        ProcessOutputRedirector outRedirection = new ProcessOutputRedirector(process.getInputStream(), out);
        ProcessOutputRedirector errRedirection = new ProcessOutputRedirector(process.getErrorStream(), err);
        int exit = process.waitFor();
        outRedirection.join();
        errRedirection.join();
        return exit;
    }

    private ProcessExecutor() {
        throw new Error();
    }
}

