/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.terminal;

import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteTerminal;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteTerminalProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class Main {
    public static void main(String[] args) throws IOException, NotBoundException {
        RemoteTerminalProvider provider;
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        Registry registry = LocateRegistry.getRegistry(host, port);
        try {
            try {
                provider = (RemoteTerminalProvider)registry.lookup("CI_Master");
            }
            catch (NotBoundException e) {
                provider = (RemoteTerminalProvider)registry.lookup("CI_Slave");
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        RemoteTerminal terminal = provider.createTerminal();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(System.in));){
            String prompt = host + ":" + port + "$ ";
            boolean active = true;
            while (active) {
                System.out.print(prompt);
                String input = in.readLine();
                if (input == null || input.equals("exit")) {
                    active = false;
                    continue;
                }
                if (input.trim().equals("")) continue;
                System.out.println("Executing: " + input);
                String output = terminal.execute(input.trim());
                if (output == null) continue;
                System.out.println(output.trim());
            }
        }
        terminal.dispose();
    }
}

