/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.view.overview;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.model.overview.OverviewBuildsModel;
import at.jku.ssw.mevss.cerberus.ci.client.model.overview.OverviewTestsModel;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.BooleanArrayRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.BooleanRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.DateRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.renderer.RunnableRenderer;
import at.jku.ssw.mevss.cerberus.ci.client.view.dialogs.StartBuildDialog;
import at.jku.ssw.mevss.cerberus.ci.client.view.main.CerberusCloseableTabbedPane;
import at.jku.ssw.mevss.cerberus.ci.interfaces.data.Capability;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;

public class OverviewView
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Logger LOGGER = Logger.getLogger(this.getClass().getSimpleName());

    public OverviewView(RemoteProjectAccess data, CerberusCloseableTabbedPane tabs) {
        this.createOverview(data, tabs);
    }

    private void createOverview(RemoteProjectAccess data, CerberusCloseableTabbedPane tabs) {
        this.LOGGER.fine("setting up UI - Overview");
        this.LOGGER.finer("setting up UI - Overview - Schedule");
        JTextArea scheduleTextArea = new JTextArea();
        scheduleTextArea.setEditable(false);
        scheduleTextArea.setBackground(Color.WHITE);
        scheduleTextArea.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        Runnable setScheduleText = () -> {
            String runningTest = "Running:\n    -> " + data.getRunningTask();
            String schedule = Stream.of(data.buildAccess.get()).reduce("Schedule:", (a, b) -> a + "\n    -> " + b);
            scheduleTextArea.setText(runningTest + "\n" + schedule);
        };
        setScheduleText.run();
        JButton btnReloadSchedule = new JButton("Reload");
        btnReloadSchedule.addActionListener(e -> setScheduleText.run());
        JPanel schedulePanel = new JPanel(new BorderLayout(10, 0));
        schedulePanel.setBorder(new TitledBorder("Schedule"));
        schedulePanel.add((Component)scheduleTextArea, "Center");
        schedulePanel.add((Component)btnReloadSchedule, "East");
        this.LOGGER.finer("setting up UI - Overview - Builds");
        final JTable builds = new JTable();
        builds.setModel(new OverviewBuildsModel(data, id -> tabs.openTestDetails(data, (BuildID)id, null), id -> new StartBuildDialog(data, id.toEnv(), null, null, false)));
        builds.setSelectionMode(0);
        builds.setDefaultRenderer(Date.class, new DateRenderer());
        builds.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        builds.setDefaultRenderer(Boolean[].class, new BooleanArrayRenderer());
        builds.setDefaultRenderer(Runnable.class, RunnableRenderer.INSTANCE);
        builds.setDefaultEditor(Runnable.class, RunnableRenderer.INSTANCE);
        builds.setAutoCreateRowSorter(true);
        builds.setTableHeader(new JTableHeader(builds.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return builds.getModel().getColumnName(index);
            }
        });
        JScrollPane buildsScroller = new JScrollPane(builds);
        buildsScroller.setBorder(new TitledBorder("Builds"));
        this.LOGGER.finer("setting up UI - Overview - Tests");
        final JTable testsTable = new JTable();
        testsTable.setModel(new OverviewTestsModel(data, (id, test) -> tabs.openTestDetails(data, (BuildID)id, (String)test), (env, test) -> new StartBuildDialog(data, (BuildID)env, new String[]{test}, new String[0], false), Capability.FUNCTIONAL_TEST));
        testsTable.setSelectionMode(0);
        testsTable.setAutoCreateRowSorter(true);
        testsTable.setDefaultRenderer(Date.class, new DateRenderer());
        testsTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        testsTable.setDefaultRenderer(Boolean[].class, new BooleanArrayRenderer());
        testsTable.setDefaultRenderer(Runnable.class, RunnableRenderer.INSTANCE);
        testsTable.setDefaultEditor(Runnable.class, RunnableRenderer.INSTANCE);
        testsTable.setTableHeader(new JTableHeader(testsTable.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return testsTable.getModel().getColumnName(index);
            }
        });
        JScrollPane testsScroller = new JScrollPane(testsTable);
        testsScroller.setBorder(new TitledBorder("Tests"));
        this.LOGGER.finer("setting up UI - Overview - Tests");
        final JTable performanceTestsTable = new JTable();
        performanceTestsTable.setModel(new OverviewTestsModel(data, (id, test) -> tabs.openPerformanceTestDetails(data, (BuildID)id, (String)test), (env, test) -> new StartBuildDialog(data, (BuildID)env, new String[0], new String[]{test}, false), Capability.PERFORMANCE_TEST));
        performanceTestsTable.setSelectionMode(0);
        performanceTestsTable.setAutoCreateRowSorter(true);
        performanceTestsTable.setDefaultRenderer(Date.class, new DateRenderer());
        performanceTestsTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        performanceTestsTable.setDefaultRenderer(Boolean[].class, new BooleanArrayRenderer());
        performanceTestsTable.setDefaultRenderer(Runnable.class, RunnableRenderer.INSTANCE);
        performanceTestsTable.setDefaultEditor(Runnable.class, RunnableRenderer.INSTANCE);
        performanceTestsTable.setTableHeader(new JTableHeader(performanceTestsTable.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return performanceTestsTable.getModel().getColumnName(index);
            }
        });
        JScrollPane performanceTestsScroller = new JScrollPane(performanceTestsTable);
        performanceTestsScroller.setBorder(new TitledBorder("Performance Tests"));
        this.setLayout(new BoxLayout(this, 1));
        this.add(schedulePanel);
        this.add(buildsScroller);
        this.add(testsScroller);
        this.add(performanceTestsScroller);
    }
}

