/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.view.main;

import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.errors.Errors;
import at.jku.ssw.mevss.cerberus.ci.client.view.history.HistoryView;
import at.jku.ssw.mevss.cerberus.ci.client.view.main.CerberusCloseableTabbedPane;
import at.jku.ssw.mevss.cerberus.ci.client.view.main.CerberusMenuBar;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteMaster;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.RemoteProject;
import at.jku.ssw.mevss.cerberus.ci.shared.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static Logger LOGGER = Logger.getLogger(MainFrame.class.getName());

    public static JFrame create(String host, RemoteMaster master, RemoteProject project) throws Exception {
        JFrame frame = new JFrame();
        LOGGER.info("setting up interface to remote project");
        Thread.UncaughtExceptionHandler errorhandler = (__, e) -> {
            Errors.show(frame, "Error", "An error has occoured!", e);
            frame.dispose();
        };
        final RemoteProjectAccess data = new RemoteProjectAccess(host, master, project, errorhandler);
        LOGGER.info("setting up UI");
        frame.setIconImage(Toolkit.getDefaultToolkit().getImage("./cerberus_icon.jpg"));
        frame.setTitle("Cerberus CI Client - " + project.getName());
        frame.setDefaultCloseOperation(2);
        frame.setPreferredSize(new Dimension(1000, 1000));
        CerberusMenuBar menuBar = new CerberusMenuBar(frame, data);
        frame.setJMenuBar(menuBar);
        JPanel panel = new JPanel();
        frame.getContentPane().add(panel);
        panel.setLayout(new BorderLayout());
        CerberusCloseableTabbedPane tabs = new CerberusCloseableTabbedPane(frame);
        tabs.addOverview(data);
        HistoryView historyView = tabs.addHistory(data);
        tabs.addChangeListener(e -> {
            if (((CerberusCloseableTabbedPane)e.getSource()).getSelectedIndex() == 1) {
                historyView.onOpen();
            }
        });
        JLabel version = new JLabel("Version: " + Version.get());
        panel.add((Component)tabs, "Center");
        panel.add((Component)version, "South");
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent __) {
            }

            @Override
            public void windowClosing(WindowEvent __) {
            }

            @Override
            public void windowClosed(WindowEvent __) {
                try {
                    data.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "error", e);
                }
            }

            @Override
            public void windowIconified(WindowEvent __) {
            }

            @Override
            public void windowDeiconified(WindowEvent __) {
            }

            @Override
            public void windowActivated(WindowEvent __) {
            }

            @Override
            public void windowDeactivated(WindowEvent __) {
            }
        });
        frame.pack();
        frame.setExtendedState(frame.getExtendedState() | 6);
        frame.setVisible(true);
        LOGGER.info("opened");
        return frame;
    }
}

