/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.view.main;

import at.jku.ssw.mevss.cerberus.ci.client.AutoConfig;
import at.jku.ssw.mevss.cerberus.ci.client.Client;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.view.dialogs.StartBuildDialog;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class CerberusMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private RemoteProjectAccess data;
    private JFrame frame;

    public CerberusMenuBar(JFrame frame, RemoteProjectAccess data) {
        this.data = data;
        this.frame = frame;
        this.createMenuBar();
    }

    private void createMenuBar() {
        JMenu fm = new JMenu("File");
        this.add(fm);
        JMenuItem ei = new JMenuItem("Exit");
        fm.add(ei);
        ei.addActionListener(e -> this.frame.dispose());
        JMenu pm = new JMenu("Project");
        this.add(pm);
        JMenuItem si = new JMenuItem("Switch project ...");
        pm.add(si);
        si.addActionListener(e -> {
            this.frame.dispose();
            AutoConfig.set("project", null);
            Client.startMainWithLastKnowConnection();
        });
        JMenuItem sc = new JMenuItem("Open another project ...");
        pm.add(sc);
        sc.addActionListener(e -> {
            AutoConfig.set("project", null);
            Client.startMainWithLastKnowConnection();
        });
        pm.addSeparator();
        JMenuItem bi = new JMenuItem("Build ...");
        pm.add(bi);
        bi.addActionListener(e -> new StartBuildDialog(this.data, null, new String[0], new String[0], false));
        JMenuItem ti = new JMenuItem("Functional test ...");
        pm.add(ti);
        ti.addActionListener(e -> new StartBuildDialog(this.data, null, null, new String[0], false));
        JMenuItem pti = new JMenuItem("Performance test ...");
        pm.add(pti);
        pti.addActionListener(e -> new StartBuildDialog(this.data, null, new String[0], null, false));
        JMenuItem di = new JMenuItem("Deploy ...");
        pm.add(di);
        di.addActionListener(e -> new StartBuildDialog(this.data, null, new String[0], new String[0], true));
        JMenu hm = new JMenu("Help");
        this.add(hm);
        JMenuItem ai = new JMenuItem("About Cerberus");
        hm.add(ai);
        ai.addActionListener(e -> CerberusMenuBar.showAbout());
    }

    private static void showAbout() {
        ImageIcon icon = new ImageIcon("./monkey.gif");
        JLabel label = new JLabel(icon);
        JFrame f = new JFrame("About Cerberus");
        f.getContentPane().add(label);
        f.setIconImage(Toolkit.getDefaultToolkit().getImage("./cerberus_icon.jpg"));
        f.setAlwaysOnTop(true);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }
}

