/*
 * Decompiled with CFR 0.152.
 */
package at.jku.ssw.mevss.cerberus.ci.client.view.main;

import at.jku.ssw.mevss.cerberus.ci.client.Client;
import at.jku.ssw.mevss.cerberus.ci.client.data.RemoteProjectAccess;
import at.jku.ssw.mevss.cerberus.ci.client.errors.Errors;
import at.jku.ssw.mevss.cerberus.ci.client.util.JCloseableTabbedPane;
import at.jku.ssw.mevss.cerberus.ci.client.view.details.DetailsView;
import at.jku.ssw.mevss.cerberus.ci.client.view.history.HistoryView;
import at.jku.ssw.mevss.cerberus.ci.client.view.overview.OverviewView;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildID;
import at.jku.ssw.mevss.cerberus.ci.interfaces.rmi.BuildInfo;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class CerberusCloseableTabbedPane
extends JCloseableTabbedPane {
    private static final long serialVersionUID = 1L;
    private final Logger LOGGER = Logger.getLogger(this.getClass().getSimpleName());
    private final JFrame parentFrame;

    public CerberusCloseableTabbedPane(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void openTestDetails(RemoteProjectAccess data, BuildID id, String test) {
        this.LOGGER.fine("opening UI - Details for " + id);
        String header = Client.createDetailsHeader(id, (BuildInfo)data.getValue(id));
        if (!this.selectTab(header)) {
            ArrayList<Closeable> closeables = new ArrayList<Closeable>();
            JComponent content = this.createDetails(data, id, test, null, closeables);
            ImageIcon icon = this.getEnvironmentIcon(id.toEnv());
            this.addTab(header, icon, content, true, () -> this.closeAll(closeables));
        }
        this.parentFrame.pack();
    }

    public void openPerformanceTestDetails(RemoteProjectAccess data, BuildID id, String performanceTest) {
        this.LOGGER.fine("opening UI - Details for " + id);
        String header = Client.createDetailsHeader(id, (BuildInfo)data.getValue(id));
        if (!this.selectTab(header)) {
            ArrayList<Closeable> closeables = new ArrayList<Closeable>();
            JComponent content = this.createDetails(data, id, null, performanceTest, closeables);
            ImageIcon icon = this.getEnvironmentIcon(id.toEnv());
            this.addTab(header, icon, content, true, () -> this.closeAll(closeables));
        }
        this.parentFrame.pack();
    }

    public OverviewView addOverview(RemoteProjectAccess data) {
        OverviewView overview = new OverviewView(data, this);
        this.addTab("Overview", overview);
        this.parentFrame.pack();
        return overview;
    }

    public HistoryView addHistory(RemoteProjectAccess data) throws RemoteException {
        HistoryView history = new HistoryView(data, this);
        this.addTab("History", history);
        this.parentFrame.pack();
        return history;
    }

    private JComponent createDetails(RemoteProjectAccess data, BuildID id, String test, String performanceTest, List<Closeable> closeables) {
        this.LOGGER.fine("creating UI - Details for " + id);
        DetailsView innerTabs = new DetailsView(this, data, id, test, performanceTest, closeables);
        return innerTabs;
    }

    private ImageIcon getEnvironmentIcon(BuildID env) {
        int size = 15;
        ImageIcon icon = new ImageIcon(env.toEnv().getOS().toLowerCase() + ".png");
        Image image = icon.getImage();
        BufferedImage buffer = new BufferedImage(15, 15, 2);
        buffer.getGraphics().drawImage(image, 0, 0, 15, 15, null);
        return new ImageIcon(buffer);
    }

    private void closeAll(List<Closeable> closeables) {
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                Errors.showInternal(this, e);
            }
        }
    }
}

